package com.tydic.dyc.act.model.api;

import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityCatalogInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeRspDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeSupplierInfo;
import com.tydic.dyc.base.bo.BasePageRspBo;

/**
 * 描述: 〈活动变更子域相关方法〉
 * @author : yuhao
 * @date : 2023/12/12 15:15
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActivityChangeModel {

    /**
     * 描述:活动变更单基本信息查询服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeRspDO
     */
    DycActivityChangeRspDO queryActivityChangeBaseInfo(DycActivityChangeDO reqBO);

    /**
     * 描述:活动变更已选供应商列表查询（分页）服务
     *
     * @param
     * @return void
     */
    BasePageRspBo<DycActivityChangeSupplierInfo> queryActivityChangeSelectedSupplierPageList(DycActivityChangeDO reqBO);
    /**
     * 描述:活动变更服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeInfo
     */
    DycActivityChangeInfo changeActivity(DycActivityChangeDO reqBO);

    /**
     * 描述:活动变更供应商选择（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeRspDO
     */
    int batchSelectActivityChangeSupplier(DycActivityChangeDO reqBO);
    /**
     * 描述:活动变更供应商移除（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeRspDO
     */
    int batchRemoveActivityChangeSupplier(DycActivityChangeDO reqBO);

    /**
     * 描述:活动变更已选商品池列表查询（分页）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.base.bo.BasePageRspBo<com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityPoolInfo>
     */
    BasePageRspBo<DycActivityChangeRelaCommodityPoolInfo> queryActivityChangeCommodityPoolPageList(DycActivityChangeDO reqBO);
    /**
     * 描述:活动变更商品池选择（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityPoolInfo
     */
    DycActivityChangeRelaCommodityPoolInfo batchSelectActivityChangeCommodityPool(DycActivityChangeDO reqBO);
    /**
     * 描述:活动变更商品池移除（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityPoolInfo
     */
    DycActivityChangeRelaCommodityPoolInfo batchRemoveActivityChangeCommodityPool(DycActivityChangeDO reqBO);


    /**
     * 描述:活动变更已选商品类型列表查询（分页）服务
     *
     * @param
     * @return void
     */
    BasePageRspBo<DycActivityChangeRelaCommodityCatalogInfo> queryActivityChangeSelectedCommodityCatalogPageList(DycActivityChangeDO reqBO);

    /**
     * 描述:活动变更商品类型选择（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeRspDO
     */
    int batchSelectActivityChangeCommodityCatalog(DycActivityChangeDO reqBO);

    /**
     * 描述:活动变更商品类型移除（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeRspDO
     */
    int batchRemoveActivityChangeCommodityCatalog(DycActivityChangeDO reqBO);
    /**
     * 描述:活动变更已选用户列表查询（分页）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeUserInfo
     */
    BasePageRspBo<DycActivityChangeUserInfo> queryActivityChangeUserPageList(DycActivityChangeDO reqBO);

    /**
     * 描述:活动变更已选商品类型列表查询（分页）服务
     *
     * @param
     * @return void
     */
    BasePageRspBo<DycActivityChangeRelaCommodityInfo> queryActivityChangeCommodityPageList(DycActivityChangeDO reqBO);
    /**
     * 描述:活动变更用户选择（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeUserInfo
     */
    int batchSelectActivityChangeUser(DycActivityChangeDO reqBO);
    /**
     * 描述:活动变更用户移除（批量）服务
     *
     * @param reqBO
     * @return int
     */
    int batchRemoveActivityChangeUser(DycActivityChangeDO reqBO);

    /**
     * 描述:活动变更商品选择（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeRspDO
     */
    int batchSelectActivityChangeCommodity(DycActivityChangeDO reqBO);

    /**
     * 描述:活动变更商品移除（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeRspDO
     */
    int batchRemoveActivityChangeCommodity(DycActivityChangeDO reqBO);

    /**
     * 活动变更用户导入服务
     * @param dycActImportActivityUserModelReqBO
     * @return
     */
    DycActImportActivityUserModelRspBO importActivityChangeUser(DycActImportActivityUserModelReqBO dycActImportActivityUserModelReqBO);

    /**
     * 活动变更用户积分修改（批量）服务
     * @param dycActivityChangeDO
     * @return
     */
    int batchModifyActivityChangeUserScores(DycActivityChangeDO dycActivityChangeDO);

    /**
     * 活动变更用户积分修改服务
     * @param dycActivityChangeDO
     * @return
     */
    int modifyActivityChangeUserScores(DycActivityChangeDO dycActivityChangeDO);

    /**
     * 描述:活动变更状态变更服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeInfo
     */
    DycActivityChangeInfo changeActivityChangeState(DycActivityChangeDO reqBO);

    /**
     * 描述:活动变更已选用户列表查询（分页）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeUserInfo
     */
    BasePageRspBo<DycActivityChangeInfo> queryActivityChangePageList(DycActivityChangeDO reqBO);

}
