package com.tydic.dyc.act.model.bo;

import lombok.Data;

import java.io.Serializable;
import java.math.BigDecimal;
import java.util.Date;
/**
 * 描述: 〈活动基本信息对象〉
 * @author : yuhao
 * @date : 2023/12/12 15:46
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class DycActivityBaseInfo implements Serializable {

    /**
     * 活动id
     */
    private Long activityId;
    /**
     * 活动版本号
     */
    private Integer activityVersion;
    /**
     * 活动编号
     */
    private String activityCode;
    /**
     * 活动适用组织id
     */
    private Long activityScopeOrgId;
    /**
     * 活动适用组织名称
     */
    private String activityScopeOrgName;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 发票ID
     */
    private Long invoiceId;
    /**
     * 发票抬头
     */
    private String invoiceTitle;
    /**
     * 发票类别;1:纸质发票 2:电子发票
     */
    private Integer invoiceClass;
    /**
     * 发票类别翻译
     */
    private String invoiceClassStr;
    /**
     * 发票类型:1:专用发票；2：普通发票
     */
    private Integer invoiceType;
    /**
     * 发票类型翻译
     */
    private String invoiceTypeStr;
    /**
     * 发票纳税人识别号
     */
    private String invoiceTaxpayerId;
    /**
     * 发票开户银行
     */
    private String invoiceBank;
    /**
     * 发票开户银行账户
     */
    private String invoiceBankAccount;
    /**
     * 发票地址
     */
    private String invoiceAddress;
    /**
     * 发票电话
     */
    private String invoicePhone;
    /**
     * 活动类型:1:工会活动；2：劳防活动
     */
    private Integer activityType;
    /**
     * 活动类型翻译
     */
    private String activityTypeStr;
    /**
     * 活动期限:1:有限期，2:无限期
     */
    private Integer activityCycleType;
    /**
     * 活动开始时间
     */
    private Date activityStartTime;
    /**
     * 活动结束时间
     */
    private Date activityEndTime;
    /**
     * 支付方式:1:积分支付；2：混合支付
     */
    private Integer activityPayMode;
    /**
     * 支付方式翻译
     */
    private String activityPayModeStr;
    /**
     * 活动备注
     */
    private String remark;
    /**
     * 活动状态:1:草稿；2：待审批；3：已驳回；4：启用；5：已生效；6：停用；7：已失效；8：变更中
     */
    private String activityState;
    /**
     * 活动状态翻译
     */
    private String activityStateStr;
    /**
     * 删除标志
     0:未删除；1：已删除
     */
    private Integer delFlag;
    /**
     * 代币id
     */
    private Long tokenId;
    /**
     * 代币数量
     */
    private BigDecimal tokenNumber;
    /**
     * 货币金额
     */
    private BigDecimal convertAmount;
    /**
     * 货币单位
     */
    private String convertUnit;
    /**
     * 商品最高价格
     */
    private BigDecimal maxPrice;
    /**
     * 商品最低价格
     */
    private BigDecimal minPrice;
    /**
     * 商品关联方式:1:商品池；2：商品类型；3：商品
     */
    private Integer commodityRelaMethod;
    /**
     * 创建时间
     */
    private Date createTime;
    /**
     * 创建人ID
     */
    private Long createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 更新时间
     */
    private Date updateTime;
    /**
     * 更新人名称
     */
    private String updateUserName;
    /**
     * 更新人ID
     */
    private Long updateUserId;
    /**
     * 创建人机构ID
     */
    private Long createOrgId;
    /**
     * 创建人机构名称
     */
    private String createOrgName;
    /**
     * 创建人机构路径
     */
    private String createOrgTreePath;
    /**
     * 创建人公司ID
     */
    private Long createCompanyId;
    /**
     * 创建人公司名称
     */
    private String createCompanyName;
}
