package com.tydic.dyc.act.model.bo;

import com.tydic.dyc.base.bo.BasePageReqBo;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述: 〈活动基本信息查询对象〉
 * @author : yuhao
 * @date : 2023/12/12 15:39
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class DycActivityDO extends BasePageReqBo {

    private static final long serialVersionUID = 5716364943750564258L;
    /**
     * 活动id
     */
    private Long activityId;
    /**
     * 活动版本号
     */
    private Integer activityVersion;
    /**
     * 活动编号
     */
    private String activityCode;
    /**
     * 活动适用组织id
     */
    private Long activityScopeOrgId;
    /**
     * 活动适用组织名称
     */
    private String activityScopeOrgName;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 活动类型:1:工会活动；2：劳防活动
     */
    private Integer activityType;
    /**
     * 活动期限:1:有限期，2:无限期
     */
    private Integer activityCycleType;
    /**
     * 支付方式:1:积分支付；2：混合支付
     */
    private Integer activityPayMode;
    /**
     * 活动状态:1:草稿；2：待审批；3：已驳回；4：启用；5：已生效；6：停用；7：已失效；8：变更中
     */
    private String activityState;
    /**
     * 删除标志
     0:未删除；1：已删除
     */
    private Integer delFlag;
    /**
     * 商品关联方式:1:商品池；2：商品类型；3：商品
     */
    private Integer commodityRelaMethod;
    /**
     * 创建人ID
     */
    private Long createUserId;
    /**
     * 创建人名称
     */
    private String createUserName;
    /**
     * 更新人名称
     */
    private String updateUserName;
    /**
     * 更新人ID
     */
    private Long updateUserId;
    /**
     * 创建人机构ID
     */
    private Long createOrgId;
    /**
     * 创建人机构名称
     */
    private String createOrgName;
    /**
     * 创建人机构路径
     */
    private String createOrgTreePath;
    /**
     * 创建人公司ID
     */
    private Long createCompanyId;
    /**
     * 创建人公司名称
     */
    private String createCompanyName;
    /**
     * 商品类型ID
     */
    private Long commodityTypeId;
    /**
     * 商品类型名称
     */
    private String commodityTypeName;
    /**
     * 单品ID
     */
    private Long skuId;
    /**
     * 单品编码
     */
    private String skuCode;
    /**
     * 单品名称
     */
    private String skuName;
    /**
     * 用户id
     */
    private Long userId;
    /**
     * 用户名
     */
    private String userName;
    /**
     * 用户姓名
     */
    private String name;
    /**
     * 电话
     */
    private String phone;
    /**
     * 工号
     */
    private String workNo;
    /**
     * 积分状态（0：正常，1：冻结）
     */
    private Integer scoresType;
    /**
     * 发放积分（第一次的发放）
     */
    private BigDecimal giveScores;
    /**
     * 已使用积分
     */
    private BigDecimal usedScores;
    /**
     * 剩余可用积分
     */
    private BigDecimal balanceScores;
    /**
     * 过期积分
     */
    private BigDecimal loseScores;
    /**
     * 剩余可用金额（按照活动代币ID中的规则转换为法币价值）
     */
    private BigDecimal effMoney;
    /**
     * 用户所属组织ID
     */
    private Long userOrgId;
    /**
     * 用户所属组织名称
     */
    private String userOrgName;
    /**
     * 业务对象ID
     */
    private Long objId;
    /**
     * 业务对象类型:
     1：活动
     2：活动变更单
     3：审批单
     */
    private Integer objType;
    /**
     * 供应商id集合
     */
    private List<Long> supplierIds;
    /**
     * 商品池id列表
     */
    private List<Long> commodityPoolIdList;
    /**
     * 商品类型Id列表
     */
    private List<Long> commodityTypeIdList;
    /**
     * 商品id列表
     */
    private List<Long> skuIdList;
    /**
     * 商品池列表列表
     */
    private List<DycActivityCommodityPoolInfo> activityCommodityPoolInfos;
    /**
     * 商品类型列表
     */
    private List<DycActiveCommodityCatalogInfo> commodityCatalogInfoBOS;
    /**
     *商品列表
     */
    private List<DycActActivityRelaCommodityInfo> actActivityRelaCommodityBOS;
    /**
     * 活动用户列表
     */
    private List<DycActivityUserInfo> activityUserList;
    /**
     * 	用户id列表
     */
    private List<Long> userIdList;
    /**
     * 单据编号
     */
    private String objCode;
    /**
     * 使用人名称
     */
    private String useUserName;
    /**
     * 使用人Id
     */
    private Long useUserId;
    /**
     * 使用开始时间
     */
    private Date useStartTime;
    /**
     * 使用结束时间
     */
    private Date useEndTime;
    /**
     * 操作类型：2：消费:3：退回
     */
    private String operType;
    /**
     * 使用/退回积分
     */
    private BigDecimal useScores;
    /**
     * 使用时间
     */
    private Date useTime;
}
