package com.tydic.dyc.act.model.bo;

import com.tydic.dyc.act.service.bo.DycActTaskBO;
import com.tydic.dyc.base.bo.BasePageReqBo;
import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;
import java.util.List;

/**
 * 描述: 〈活动基本信息查询对象〉
 * @author : yuhao
 * @date : 2023/12/12 15:39
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Data
public class DycProcessDO extends BasePageReqBo {

    private static final long serialVersionUID = 5716364943750564258L;
    /**
     * 活动编号
     */
    private String activityCode;
    /**
     * 活动名称
     */
    private String activityName;
    /**
     * 当前登录人Id
     */
    private Long userId;
    /**
     * 页签Id：1：待审批；2：已审批；3：全部
     */
    private String tabId;
    /**
     * 活动更新人名称
     */
    private String updateUserName;
    /**
     * 活动变更人名称
     */
    private String changeUserName;
    /**
     * 活动开始开始时间
     */
    private Date activityStartStartTime;
    /**
     * 活动开始结束时间
     */
    private Date activityStartEndTime;
    /**
     * 活动更新开始时间
     */
    private Date updateStartTime;
    /**
     * 活动更新结束时间
     */
    private Date updateEndTime;


    /**
     * 下一步任务信息（使用范围：前加签，流转）
     */
    private List<DycActTaskBO> nextTaskInfos;
    /**
     * 是否使用待定
     */
    private List<DycActTaskBO> completeTaskInfos;
    /**
     * 确认结果
     */
    private String opFlag;
    /**
     * 执行了前加签的任务ID
     */
    private String preTaskId;
    /**
     * 执行了回退的任务ID
     */
    private String returnTaskId;
    /**
     *  修改任务处理人（转签）
     */
    private DycActTaskBO updateTaskCandidate;
    /**
     * 源业务对象类型
     */
    private String sourceBusiObjType;
    /**
     * 撤回任务信息
     */
    private List<DycActTaskBO> recallTaskInfos;
    /**
     * 流程实例ID
     * 如果有值代表，当前整个审批结束
     */
    private String procInstId;
    /**
     * 流程实例id
     */
    private String flowInstId;
    /**
     * 任务id
     */
    private String taskId;



    /**
     * ID
     */
    private Long id;


    private List<DycActivityFlowInstanceInfo> flowInstanceInfoList;

    private List<DycActivityFlowTaskInfo> flowTaskInfosList;
}
