package com.tydic.dyc.act.model.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.*;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 描述: 〈活动子域相关方法实现〉
 *
 * @author : yuhao
 * @date : 2023/12/12 15:14
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Service
public class DycActActivityModelImpl implements DycActActivityModel {


    @Autowired
    private DycActActivityRepository dycActActivityRepository;

    @Autowired
    private DycActFileRepository dycActFileRepository;

    @Autowired
    private DycActActivitySupplierRepository dycActActivitySupplierRepository;

    @Autowired
    private DycActActivityCommodityRepository dycActActivityCommodityRepository;

    @Autowired
    private DycActActivityUserRepository dycActActivityUserRepository;

    /**
     * 根据条件查询活动基本信息列表（分页）
     *
     * @param reqBO
     * @return
     */
    @Override
    public BasePageRspBo<DycActivityBaseInfo> queryActivityPageList(DycActivityDO reqBO) {
        return dycActActivityRepository.queryActivityPageList(reqBO);
    }

    @Override
    public List<DycActivityBaseInfo> queryActivityList(DycActivityDO reqBO) {
        return dycActActivityRepository.queryActivityList(reqBO);
    }

    @Override
    public List<DycActivityFileInfo> queryActivityFileList(DycActivityDO reqBO) {
        return dycActFileRepository.queryActivityFileList(reqBO);
    }

    /**
     * 活动可选供应商列表分页查询服务
     *
     * @param reqBO
     * @return
     */
    @Override
    public BasePageRspBo<DycActivitySupplierInfo> queryActivityUnselectSupplierPageList(DycActivityDO reqBO) {
        return dycActActivitySupplierRepository.queryActivityUnselectSupplierPageList(reqBO);
    }

    @Override
    public BasePageRspBo<DycActivitySupplierInfo> queryActiveSupplierList(DycActivityDO reqBO) {
        return dycActActivitySupplierRepository.queryActiveSupplierList(reqBO);
    }

    /**
     * 描述: 供应商批量更新
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivitySupplierInfo
     */
    @Override
    public DycActivitySupplierInfo addBatchActiveSupplier(DycActivitySupplierInfoAddBatchBO reqBO) {
        return dycActActivitySupplierRepository.addBatchActiveSupplier(reqBO);
    }

    /**
     * 描述: 供应商批量删除
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivitySupplierInfo
     */
    @Override
    public DycActivitySupplierInfo deleteBatchActiveSupplier(DycActivitySupplierInfoDeleteBatchBO reqBO) {
        return dycActActivitySupplierRepository.deleteBatchActiveSupplier(reqBO);
    }

    /**
     * 描述: 活动基本详情保存
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityFileInfo
     */
    @Override

    public DycActivityBaseInfo saveActiveBaseInfo(DycActiveBaseInfoSaveReqBO reqBO) {
        DycActivityBaseInfo baseInfo = dycActActivityRepository.saveActiveBaseInfo(reqBO);
        if (!CollectionUtils.isEmpty(reqBO.getFileInfoBOS())) {

            List<DycActivityFileInfo> dycActivityFileInfos = JSON.parseArray(JSON.toJSONString(reqBO.getFileInfoBOS()), DycActivityFileInfo.class);
            dycActivityFileInfos.forEach(item -> {
                item.setObjId(baseInfo.getActivityId());
                item.setObjType(1);
                item.setDelFlag(0);
            });
            dycActFileRepository.addListActivityFileInfo(dycActivityFileInfos);
        }
        DycActivityBaseInfo rspBO = new DycActivityBaseInfo();
        rspBO.setActivityId(baseInfo.getActivityId());
        return rspBO;

    }

    /**
     * 描述:活动已选商品池列表分页查询
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityCommodityPoolInfo
     */
    @Override
    public BasePageRspBo<DycActivityCommodityPoolInfo> queryActivityCommodityPoolPageList(DycQueryActivityCommodityPoolPageListReqBO reqBO) {
        return dycActActivityCommodityRepository.queryActivityCommodityPoolPageList(reqBO);
    }

    /**
     * 活动已选商品列表分页查询
     *
     * @param reqBO
     * @return
     */
    @Override
    public BasePageRspBo<DycActActivityRelaCommodityInfo> queryActivityCommodityPageList(DycActivityDO reqBO) {
        return dycActActivityCommodityRepository.queryActivityCommodityPageList(reqBO);
    }

    @Override
    public BasePageRspBo<DycActiveCommodityCatalogInfo> queryActiveCommodityCatalogList(DycActiveCommodityCatalogQueryBO reqBO) {
        return dycActActivityCommodityRepository.queryActiveCommodityCatalogList(reqBO);
    }

    @Override
    public DycActivityCommodityPoolInfo batchSelectActivityCommodityPool(DycActivityDO reqBO) {
        return dycActActivityCommodityRepository.batchSelectActivityCommodityPool(reqBO);
    }

    /**
     * 活动商品池移除（批量）服务
     *
     * @param reqBO
     * @return
     */
    @Override
    public int batchRemoveActivityCommodityPool(DycActivityDO reqBO) {
        return dycActActivityCommodityRepository.batchRemoveActivityCommodityPool(reqBO);
    }


    @Override
    public DycActiveCommodityCatalogInfo batchSelectActivityCommodityCatalog(DycActivityDO reqBO) {
        return dycActActivityCommodityRepository.batchSelectActivityCommodityCatalog(reqBO);
    }

    @Override
    public int batchRemoveActivityCommodityCatalog(DycActivityDO reqBO) {
        return dycActActivityCommodityRepository.batchRemoveActivityCommodityCatalog(reqBO);
    }

    @Override
    public DycActActivityRelaCommodityInfo batchSelectActivityCommodity(DycActivityDO reqBO) {
        return dycActActivityCommodityRepository.batchSelectActivityCommodity(reqBO);
    }

    @Override
    public int batchRemoveActivityCommodity(DycActivityDO reqBO) {
        return dycActActivityCommodityRepository.batchRemoveActivityCommodity(reqBO);
    }

    @Override
    public BasePageRspBo<DycActivityUserInfo> queryActivityUserPageList(DycActivityDO reqBO) {
        return dycActActivityUserRepository.queryActivityUserPageList(reqBO);
    }

    @Override
    public int changeActivityState(DycActivityDO reqBO) {
        return dycActActivityRepository.changeActivityState(reqBO);
    }

    @Override
    public int deleteActivity(DycActivityDO reqBO) {
        return dycActActivityRepository.deleteActivity(reqBO);
    }

    @Override

    public DycActivityBaseInfo copyActivity(DycActivityDO reqBO) {

        //查询活动表
        DycActivityDO activityDO = new DycActivityDO();
        activityDO.setActivityId(reqBO.getActivityId());
        List<DycActivityBaseInfo> baseInfos = dycActActivityRepository.queryActivityList(activityDO);
        if (1 != baseInfos.size()) {
            throw new ZTBusinessException("当前活动id，存在多条活动！");
        }
        //附件表查询
        DycActivityDO aDo = new DycActivityDO();
        aDo.setObjId(reqBO.getActivityId());
        aDo.setObjType(1);
        List<DycActivityFileInfo> fileInfos = dycActFileRepository.queryActivityFileList(aDo);
        //活动表的复制
        DycActiveBaseInfoSaveReqBO infoSaveReqBO = JSON.parseObject(JSON.toJSONString(baseInfos.get(0)), DycActiveBaseInfoSaveReqBO.class);
        infoSaveReqBO.setFileInfoBOS(fileInfos);
        infoSaveReqBO.setCreateUserId(reqBO.getCreateUserId());
        infoSaveReqBO.setCreateUserName(reqBO.getCreateUserName());
        DycActivityBaseInfo dycActivityBaseInfo = saveActiveBaseInfo(infoSaveReqBO);

        //活动关联商品查询以及复制
        BasePageRspBo<DycActActivityRelaCommodityInfo> infoBasePageRspBo = dycActActivityCommodityRepository.queryActivityCommodityPageList(activityDO);
        if (infoBasePageRspBo.getRows().size() > 0) {
            DycActivityDO commodityDo = new DycActivityDO();
            commodityDo.setActActivityRelaCommodityBOS(infoBasePageRspBo.getRows());
            commodityDo.setActivityId(dycActivityBaseInfo.getActivityId());
            commodityDo.setCreateUserId(reqBO.getCreateUserId());
            commodityDo.setCreateUserName(reqBO.getCreateUserName());
            dycActActivityCommodityRepository.batchSelectActivityCommodity(commodityDo);
        }
        //活动关联商品池查询以及复制
        DycQueryActivityCommodityPoolPageListReqBO poolPageListReqBO = new DycQueryActivityCommodityPoolPageListReqBO();
        poolPageListReqBO.setActivityId(reqBO.getActivityId());
        BasePageRspBo<DycActivityCommodityPoolInfo> poolInfoBasePageRspBo = dycActActivityCommodityRepository.queryActivityCommodityPoolPageList(poolPageListReqBO);
        if (poolInfoBasePageRspBo.getRows().size() > 0) {
            DycActivityDO commodityDo = new DycActivityDO();
            commodityDo.setActivityCommodityPoolInfos(poolInfoBasePageRspBo.getRows());
            commodityDo.setActivityId(dycActivityBaseInfo.getActivityId());
            commodityDo.setCreateUserId(reqBO.getCreateUserId());
            commodityDo.setCreateUserName(reqBO.getCreateUserName());
            dycActActivityCommodityRepository.batchSelectActivityCommodityPool(commodityDo);
        }
        //活动关联商品类型查询以及复制
        DycActiveCommodityCatalogQueryBO catalogQueryBO = new DycActiveCommodityCatalogQueryBO();
        catalogQueryBO.setActivityId(reqBO.getActivityId());
        BasePageRspBo<DycActiveCommodityCatalogInfo> catalogInfoBasePageRspBo = dycActActivityCommodityRepository.queryActiveCommodityCatalogList(catalogQueryBO);
        if (catalogInfoBasePageRspBo.getRows().size() > 0) {
            DycActivityDO commodityDo = new DycActivityDO();
            commodityDo.setCommodityCatalogInfoBOS(catalogInfoBasePageRspBo.getRows());
            commodityDo.setActivityId(dycActivityBaseInfo.getActivityId());
            commodityDo.setCreateUserId(reqBO.getCreateUserId());
            commodityDo.setCreateUserName(reqBO.getCreateUserName());
            dycActActivityCommodityRepository.batchSelectActivityCommodityCatalog(commodityDo);
        }
        //活动关联供应商查询以及复制
        BasePageRspBo<DycActivitySupplierInfo> supplierInfoBasePageRspBo = dycActActivitySupplierRepository.queryActiveSupplierList(activityDO);
        if (supplierInfoBasePageRspBo.getRows().size() > 0) {
            DycActivitySupplierInfoAddBatchBO infoAddBatchBO = new DycActivitySupplierInfoAddBatchBO();
            infoAddBatchBO.setActivityId(dycActivityBaseInfo.getActivityId());
            infoAddBatchBO.setSupplierList(supplierInfoBasePageRspBo.getRows());
            dycActActivitySupplierRepository.addBatchActiveSupplier(infoAddBatchBO);
        }
        //活动关联用户查询以及复制
        BasePageRspBo<DycActivityUserInfo> userInfoBasePageRspBo = dycActActivityUserRepository.queryActivityUserPageList(activityDO);
        if (userInfoBasePageRspBo.getRows().size() > 0) {
            DycActivityDO userDO = new DycActivityDO();
            userDO.setCreateUserName(reqBO.getCreateUserName());
            userDO.setCreateUserId(reqBO.getCreateUserId());
            userDO.setActivityId(reqBO.getActivityId());
            userDO.setActivityUserList(userInfoBasePageRspBo.getRows());
            dycActActivityUserRepository.batchSelectActivityUser(userDO);
        }

        return dycActivityBaseInfo;
    }

    @Override
    public DycActivityUserInfo batchSelectActivityUser(DycActivityDO reqBO) {
        return dycActActivityUserRepository.batchSelectActivityUser(reqBO);
    }

    @Override
    public DycActivityUserInfo batchRemoveActivityUser(DycActivityDO reqBO) {
        return dycActActivityUserRepository.batchRemoveActivityUser(reqBO);
    }

    @Override
    public DycActivityUserInfo modifyActivityUserScores(DycActivityDO reqBO) {
        return dycActActivityUserRepository.modifyActivityUserScores(reqBO);
    }

    @Override
    public DycActImportActivityUserModelRspBO importActivityUser(DycActImportActivityUserModelReqBO reqBO) {
        DycActImportActivityUserModelRspBO rspBO = new DycActImportActivityUserModelRspBO();
        DycActImportActivityUserModelBO dycActImportActivityUserModelBO = new DycActImportActivityUserModelBO();
        List<DycActImportActivityUserInfoModelBO> list = new ArrayList<>();
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参为空");
        }
        JSONObject jsonObject = JSON.parseObject(reqBO.getRequestParam());
        if (!jsonObject.containsKey("activityId") || !jsonObject.containsKey("userId") || !jsonObject.containsKey("name")) {
            throw new ZTBusinessException("入参为空");
        }
        //得到活动id、操作人id、操作人名称
        String activityId = jsonObject.get("activityId").toString();
        String userId = jsonObject.get("userId").toString();
        String name = jsonObject.get("name").toString();
        if (StringUtils.isEmpty(activityId) || StringUtils.isEmpty(userId) || StringUtils.isEmpty(name)) {
            throw new ZTBusinessException("入参为空");
        }
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActivityDO.setActivityId(Long.valueOf(activityId));
        List<DycActivityUserInfo> dycActivityUserInfos = dycActActivityUserRepository.queryActivityUserList(dycActivityDO);
        Set<Long> collect = dycActivityUserInfos.stream().map(DycActivityUserInfo::getUserId).collect(Collectors.toSet());
        //得到需要添加的用户
        JSONArray userItem = jsonObject.getJSONArray("userItem");
        if (userItem.size() < 1) {
            throw new ZTBusinessException("没有需要增加的用户");
        }
        for (Object o : userItem) {
            JSONObject json = JSON.parseObject(o.toString());
            DycActImportActivityUserInfoModelBO dycActImportActivityUserInfoModelBO = new DycActImportActivityUserInfoModelBO();
            if (collect.size() > 0 && collect.contains(Long.valueOf(json.get("userId").toString()))) {
                dycActImportActivityUserInfoModelBO.setLineNum(Long.valueOf(json.get("gluttonLineNum").toString()));
                dycActImportActivityUserInfoModelBO.setFailReason("活动用户已存在");
                list.add(dycActImportActivityUserInfoModelBO);
            } else {
//                DycActivityDO dycActivityUserInfo = new DycActivityDO();
                DycActivityDO dycActivityUserInfo = JSON.parseObject(json.toString(), DycActivityDO.class);
//                dycActivityUserInfo.setUserId(Long.valueOf(json.get("userId").toString()));
//                dycActivityUserInfo.setUserName(json.get("userName").toString());
//                dycActivityUserInfo.setName(json.get("name").toString());
//                dycActivityUserInfo.setWorkNo(json.get("workNo").toString());
//                dycActivityUserInfo.setUserOrgId(Long.valueOf(json.get("userOrgId").toString()));
//                dycActivityUserInfo.setUserOrgName(json.get("userOrgName").toString());
//                dycActivityUserInfo.setPhone(json.get("phone").toString());
                dycActivityUserInfo.setActivityId(Long.valueOf(activityId));
                dycActivityUserInfo.setCreateUserId(Long.valueOf(userId));
                dycActivityUserInfo.setCreateUserName(name);
                try {
                    dycActActivityUserRepository.addUser(dycActivityUserInfo);
                } catch (Exception e) {
                    dycActImportActivityUserInfoModelBO.setLineNum(Long.valueOf(json.get("gluttonLineNum").toString()));
                    dycActImportActivityUserInfoModelBO.setFailReason(e.getMessage());
                    list.add(dycActImportActivityUserInfoModelBO);
                }
            }

        }
        dycActImportActivityUserModelBO.setFailReasonList(list);
        rspBO.setData(dycActImportActivityUserModelBO);
        return rspBO;
    }

    @Override
    public int autoEffectActivity(DycActivityDO reqBO) {
        return dycActActivityRepository.autoEffectActivity(reqBO);
    }

    @Override
    public DycActivityBaseInfo autoLoseEffectActivity(DycActivityDO reqBO) {
        return dycActActivityRepository.autoLoseEffectActivity(reqBO);
    }

    @Override
    public BasePageRspBo<DycActivityUserScoresUseRecordInfo> queryActivityUserScoresUseRecordPageList(DycActivityDO reqBO) {
        return dycActActivityUserRepository.queryActivityUserScoresUseRecordPageList(reqBO);
    }

    @Override
    public int deductOrReturnActivityScores(DycActivityDO reqBO) {
        return dycActActivityUserRepository.deductOrReturnActivityScores(reqBO);
    }

    @Override
    public DycActivityUserInfo batchModifyActivityUserScores(DycActivityDO reqBO) {
        return dycActActivityUserRepository.batchModifyActivityUserScores(reqBO);
    }
}
