package com.tydic.dyc.act.model.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.model.api.DycActProcessModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.DycActActivityChangeRepository;
import com.tydic.dyc.act.repository.api.DycActActivityRepository;
import com.tydic.dyc.act.repository.api.DycActivityFlowInstanceRepository;
import com.tydic.dyc.act.repository.api.DycActivityFlowTaskRepository;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;

/**
 * 描述: 〈流程子域相关方法实现〉
 *
 * @author : yuhao
 * @date : 2023/12/12 15:17
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Service
public class DycActProcessModelImpl implements DycActProcessModel {
    @Autowired
    private DycActActivityRepository dycActActivityRepository;
    @Autowired
    private DycActActivityChangeRepository dycActActivityChangeRepository;
    @Autowired
    private DycActivityFlowInstanceRepository dycActivityFlowInstanceRepository;
    @Autowired
    private DycActivityFlowTaskRepository dycActivityFlowTaskRepository;

    @Override
    public BasePageRspBo<DycActActivityApproveBaseInfo> queryActivityApprovePageList(DycProcessDO reqBO) {
        return dycActActivityRepository.queryActivityApprovePageList(reqBO);
    }

    @Override
    public BasePageRspBo<DycActActivityChangeApproveBaseInfo> queryActivityChangeApprovePageList(DycProcessDO reqBO) {
        return dycActActivityChangeRepository.queryActivityChangeApprovePageList(reqBO);
    }

    @Override
    public DycActivityFlowInstanceInfo dealTaskDeal(DycProcessDO reqBO) {

        //审批相关操作
        if (!CollectionUtils.isEmpty(reqBO.getNextTaskInfos()) && ObjectUtils.isEmpty(reqBO.getPreTaskId())) {
            //实例表的更新
            DycProcessDO updateReqBO = new DycProcessDO();
            List<DycActivityFlowInstanceInfo> list = new ArrayList<>();
            DycActivityFlowInstanceInfo instanceInfo = new DycActivityFlowInstanceInfo();
            instanceInfo.setObjId(Long.valueOf(reqBO.getNextTaskInfos().get(0).getBusiObjId()));
            instanceInfo.setFlowKey(reqBO.getNextTaskInfos().get(0).getProcDefKey());
            instanceInfo.setFlowDefId(reqBO.getNextTaskInfos().get(0).getProcDefId());
            instanceInfo.setFlowInstId(reqBO.getNextTaskInfos().get(0).getProcInstId());
            instanceInfo.setCurrentNodeCode(reqBO.getNextTaskInfos().get(0).getStepId());
            instanceInfo.setCurrentNodeName(reqBO.getNextTaskInfos().get(0).getStepName());
            list.add(instanceInfo);
            updateReqBO.setFlowInstanceInfoList(list);
            dycActivityFlowInstanceRepository.updateActivityFlowInstance(updateReqBO);
            //任务表插入
            List<DycActivityFlowTaskInfo> collect = new ArrayList<>();
            reqBO.getNextTaskInfos().forEach(item -> {
                item.getCandidates().forEach(itemCandidate -> {
                    DycActivityFlowTaskInfo flowTaskInfo = new DycActivityFlowTaskInfo();
                    flowTaskInfo.setTaskId(item.getTaskId());
                    flowTaskInfo.setFlowInstId(item.getProcInstId());
                    flowTaskInfo.setCurrentNodeCode(item.getStepId());
                    flowTaskInfo.setCurrentNodeName(item.getStepName());
                    flowTaskInfo.setAuditUserId(Long.valueOf(itemCandidate.getCandidateId()));
                    flowTaskInfo.setAuditUserName(itemCandidate.getCandidateName());
                    collect.add(flowTaskInfo);
                });
            });
            updateReqBO.setFlowTaskInfosList(collect);
            dycActivityFlowTaskRepository.addListActivityFlowTask(updateReqBO);
            //对完成任务做更新
            if (!CollectionUtils.isEmpty(reqBO.getCompleteTaskInfos())) {
                DycProcessDO updateTaskReqBO = new DycProcessDO();
                List<DycActivityFlowTaskInfo> listTask = new ArrayList<>();
                DycActivityFlowTaskInfo updateTaskInfo = new DycActivityFlowTaskInfo();
                updateTaskInfo.setTaskId(reqBO.getCompleteTaskInfos().get(0).getTaskId());
                updateTaskInfo.setDelFlag(1);
                updateTaskInfo.setAuditTime(new Date());
                listTask.add(updateTaskInfo);
                updateTaskReqBO.setFlowTaskInfosList(listTask);
                dycActivityFlowTaskRepository.updateActivityFlowTask(updateReqBO);
            }
        }

        //前加签操作
        if (!ObjectUtils.isEmpty(reqBO.getPreTaskId()) && !CollectionUtils.isEmpty(reqBO.getNextTaskInfos())) {
            //将原任务删除
            DycProcessDO deleteReqBO = new DycProcessDO();
            deleteReqBO.setTaskId(reqBO.getPreTaskId());
            dycActivityFlowTaskRepository.deleteActivityFlowTask(deleteReqBO);
            //添加加签后的任务
            DycProcessDO insertReqBO = new DycProcessDO();
            List<DycActivityFlowTaskInfo> collect = new ArrayList<>();
            reqBO.getNextTaskInfos().forEach(item -> {
                item.getCandidates().forEach(itemCandidate -> {
                    DycActivityFlowTaskInfo flowTaskInfo = new DycActivityFlowTaskInfo();
                    flowTaskInfo.setTaskId(item.getTaskId());
                    flowTaskInfo.setFlowInstId(item.getProcInstId());
                    flowTaskInfo.setCurrentNodeCode(item.getStepId());
                    flowTaskInfo.setCurrentNodeName(item.getStepName());
                    flowTaskInfo.setAuditUserId(Long.valueOf(itemCandidate.getCandidateId()));
                    flowTaskInfo.setAuditUserName(itemCandidate.getCandidateName());
                    collect.add(flowTaskInfo);
                });
            });
            insertReqBO.setFlowTaskInfosList(collect);
            dycActivityFlowTaskRepository.addListActivityFlowTask(insertReqBO);
        }

        //转签操作
        if (!ObjectUtils.isEmpty(reqBO.getUpdateTaskCandidate())) {
            DycProcessDO updateReqBO = new DycProcessDO();
            List<DycActivityFlowTaskInfo> flowTaskInfosList = new ArrayList<>();
            DycActivityFlowTaskInfo flowTaskInfo = new DycActivityFlowTaskInfo();
            flowTaskInfo.setTaskId(reqBO.getUpdateTaskCandidate().getTaskId());
            flowTaskInfo.setAuditUserId(Long.valueOf(reqBO.getUpdateTaskCandidate().getCandidates().get(0).getCandidateId()));
            flowTaskInfo.setAuditUserName(reqBO.getUpdateTaskCandidate().getCandidates().get(0).getCandidateName());
            flowTaskInfosList.add(flowTaskInfo);
            updateReqBO.setFlowTaskInfosList(flowTaskInfosList);
            dycActivityFlowTaskRepository.updateActivityFlowTask(updateReqBO);
        }

        //流程结束
        if (ObjectUtils.isEmpty(reqBO.getProcInstId())) {
            DycProcessDO selectRepBO = new DycProcessDO();
            selectRepBO.setFlowInstId(reqBO.getProcInstId());
            DycActivityFlowTaskInfo dycActivityFlowTaskInfo = dycActivityFlowTaskRepository.queryActivityFlowTaskSingle(selectRepBO);
            if (!ObjectUtils.isEmpty(dycActivityFlowTaskInfo)) {
                //修改实例表
                DycProcessDO updateRepBO = new DycProcessDO();
                List<DycActivityFlowInstanceInfo> flowInstanceInfoList = new ArrayList<>();
                DycActivityFlowInstanceInfo flowInstanceInfo = new DycActivityFlowInstanceInfo();
                flowInstanceInfo.setId(dycActivityFlowTaskInfo.getId());
                flowInstanceInfo.setIsFinish(0);
                flowInstanceInfo.setDelFlag(1);
                flowInstanceInfo.setAuditEndTime(new Date());
                flowInstanceInfoList.add(flowInstanceInfo);
                updateRepBO.setFlowInstanceInfoList(flowInstanceInfoList);
                dycActivityFlowTaskRepository.updateActivityFlowTask(updateRepBO);

                //修改任务表
                DycProcessDO updateTaskReqBO = new DycProcessDO();
                List<DycActivityFlowTaskInfo> flowTaskInfosList = new ArrayList<>();
                DycActivityFlowTaskInfo taskInfo = new DycActivityFlowTaskInfo();
                taskInfo.setFlowInstId(dycActivityFlowTaskInfo.getFlowInstId());
                taskInfo.setDelFlag(1);
                flowTaskInfosList.add(taskInfo);
                updateTaskReqBO.setFlowTaskInfosList(flowTaskInfosList);
                dycActivityFlowTaskRepository.updateActivityFlowTask(updateTaskReqBO);
            }
        }

        return new DycActivityFlowInstanceInfo();
    }

    @Override
    public int addActivityFlowInstance(DycProcessDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getFlowInstanceInfoList())) {
            throw new ZTBusinessException("审批实例不能为空！");
        }
        int i = dycActivityFlowInstanceRepository.addActivityFlowInstance(reqBO);
        return i;
    }
}
