package com.tydic.dyc.act.model.impl;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityConstants;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.*;
import com.tydic.dyc.act.repository.api.*;
import com.tydic.dyc.base.bo.BasePageRspBo;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import java.util.stream.Collectors;

/**
 * 描述: 〈活动变更子域相关方法实现〉
 *
 * @author : yuhao
 * @date : 2023/12/12 15:15
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
@Service
public class DycActivityChangeModelImpl implements DycActivityChangeModel {

    @Autowired
    private DycActActivityChangeRepository dycActActivityChangeRepository;
    @Autowired
    private DycActFileRepository dycActFileRepository;
    @Autowired
    private DycActActivityChangeCommodityRepository dycActActivityChangeCommodityRepository;

    @Autowired
    private DycActActivityRepository dycActActivityRepository;

    @Autowired
    private DycActActivitySupplierRepository dycActActivitySupplierRepository;

    @Autowired
    private DycActActivityCommodityRepository dycActActivityCommodityRepository;

    @Autowired
    private DycActActivityUserRepository dycActActivityUserRepository;

    @Autowired
    private DycActActivityChangeUserRepository dycActActivityChangeUserRepository;

    @Override
    public DycActivityChangeRspDO queryActivityChangeBaseInfo(DycActivityChangeDO reqBO) {

        //变更单基本信息
        DycActivityChangeRspDO rspBO = new DycActivityChangeRspDO();
        DycActivityChangeInfo changeInfo = dycActActivityChangeRepository.queryActivityChangeBaseInfo(reqBO);

        //变更单附件列表
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActivityDO.setObjId(reqBO.getChangeId());
        dycActivityDO.setObjType(2);
        List<DycActivityFileInfo> dycChangeFileInfos = dycActFileRepository.queryActivityFileList(dycActivityDO);

        //变更单活动附件列表
        DycActivityDO dycActivityFileDO = new DycActivityDO();
        dycActivityFileDO.setObjId(reqBO.getChangeId());
        dycActivityFileDO.setObjType(4);
        List<DycActivityFileInfo> dycChangeActivityFileInfos = dycActFileRepository.queryActivityFileList(dycActivityFileDO);

        rspBO.setChangeBaseDetail(changeInfo);
        rspBO.setChangeFileList(dycChangeFileInfos);
        rspBO.setChangeActivityFileList(dycChangeActivityFileInfos);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }

    @Autowired
    private DycActActivityChangeSupplierRepository dycActActivityChangeSupplierRepository;

    @Override
    public BasePageRspBo<DycActivityChangeSupplierInfo> queryActivityChangeSelectedSupplierPageList(DycActivityChangeDO reqBO) {
        return dycActActivityChangeSupplierRepository.queryActivityChangeSelectedSupplierPageList(reqBO);
    }

    @Override
    public int batchSelectActivityChangeSupplier(DycActivityChangeDO reqBO) {
        return dycActActivityChangeSupplierRepository.batchSelectActivityChangeSupplier(reqBO);
    }

    @Override
    public int batchRemoveActivityChangeSupplier(DycActivityChangeDO reqBO) {
        return dycActActivityChangeSupplierRepository.batchRemoveActivityChangeSupplier(reqBO);
    }

    @Override
    public BasePageRspBo<DycActivityChangeRelaCommodityPoolInfo> queryActivityChangeCommodityPoolPageList(DycActivityChangeDO reqBO) {
        return dycActActivityChangeCommodityRepository.queryActivityChangeCommodityPoolPageList(reqBO);
    }

    @Override
    public DycActivityChangeRelaCommodityPoolInfo batchSelectActivityChangeCommodityPool(DycActivityChangeDO reqBO) {
        return dycActActivityChangeCommodityRepository.batchSelectActivityChangeCommodityPool(reqBO);
    }

    @Override
    public DycActivityChangeRelaCommodityPoolInfo batchRemoveActivityChangeCommodityPool(DycActivityChangeDO reqBO) {
        return dycActActivityChangeCommodityRepository.batchRemoveActivityChangeCommodityPool(reqBO);
    }

    @Override

    public DycActivityChangeInfo changeActivity(DycActivityChangeDO reqBO) {

        DycActivityDO activityDO = new DycActivityDO();
        activityDO.setActivityId(reqBO.getActivityId());

        //查询活动信息
        List<DycActivityBaseInfo> activityBaseInfos = dycActActivityRepository.queryActivityList(activityDO);
        if (1 != activityBaseInfos.size()) {
            throw new ZTBusinessException("存在多条合同！");
        }
        //添加变更信息
        DycActivityChangeDO activityChangeDO = JSON.parseObject(JSON.toJSONString(activityBaseInfos.get(0)), DycActivityChangeDO.class);
        activityChangeDO.setCreateUserId(reqBO.getCreateUserId());
        activityChangeDO.setCreateUserName(reqBO.getCreateUserName());
        activityChangeDO.setOriginalActivityId(activityBaseInfos.get(0).getActivityId());
        activityChangeDO.setOriginalActivityCode(activityBaseInfos.get(0).getActivityCode());
        activityChangeDO.setOriginalActivityVersion(activityBaseInfos.get(0).getActivityVersion());
        activityChangeDO.setNewActivityVersion(activityBaseInfos.get(0).getActivityVersion() + 1);
        activityChangeDO.setUpdateTime(null);
        activityChangeDO.setUpdateUserId(null);
        activityChangeDO.setUpdateUserName("");
        DycActivityChangeInfo changeInfo = dycActActivityChangeRepository.saveActiveChangeBaseInfo(activityChangeDO);

        //变更供应商
        extractedSupplier(activityDO, changeInfo);
        //变更商品池，商品类型，商品
        switch (String.valueOf(activityBaseInfos.get(0).getCommodityRelaMethod())) {
            case DycActivityConstants.CommodityRelaMethod.COMMODITY_TYPE_ONE:
                extractedCommodityPool(reqBO, changeInfo);
                break;
            case DycActivityConstants.CommodityRelaMethod.COMMODITY_TYPE_TWO:
                extractedCatalog(reqBO, changeInfo);
                break;
            case DycActivityConstants.CommodityRelaMethod.COMMODITY_TYPE_THREE:
                extractedCommodity(reqBO, activityDO, changeInfo);
                break;
            default:
                break;
        }
        //变更用户
        extractedUser(reqBO, activityDO, changeInfo);
        //变更附件
        extractedFile(activityDO, changeInfo);

        DycActivityChangeInfo rspBO = new DycActivityChangeInfo();
        rspBO.setChangeId(changeInfo.getChangeId());
        return rspBO;
    }


    public void extractedFile(DycActivityDO activityDO, DycActivityChangeInfo changeInfo) {
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActivityDO.setObjId(activityDO.getActivityId());
        List<DycActivityFileInfo> fileInfos = dycActFileRepository.queryActivityFileList(dycActivityDO);
        if (!CollectionUtils.isEmpty(fileInfos)) {
            List<DycActivityFileInfo> collect = fileInfos.stream().map(item -> {
                DycActivityFileInfo fileInfo = new DycActivityFileInfo();
                BeanUtils.copyProperties(item, fileInfo);
                fileInfo.setObjId(changeInfo.getChangeId());
                fileInfo.setObjType(4);
                fileInfo.setDelFlag(0);
                return fileInfo;
            }).collect(Collectors.toList());
            dycActFileRepository.addListActivityFileInfo(collect);
        }
    }


    public void extractedSupplier(DycActivityDO activityDO, DycActivityChangeInfo changeInfo) {
        DycActivityChangeDO changeSupplierDO = new DycActivityChangeDO();
        List<DycActivitySupplierInfo> supplierInfos = dycActActivitySupplierRepository.queryActiveSupplierAllList(activityDO);
        if (!CollectionUtils.isEmpty(supplierInfos)) {
            List<DycActivityChangeSupplierInfo> changeSupplierInfos = JSON.parseArray(JSON.toJSONString(supplierInfos), DycActivityChangeSupplierInfo.class);
            changeSupplierDO.setChangeId(changeInfo.getChangeId());
            changeSupplierDO.setSupplierList(changeSupplierInfos);
            dycActActivityChangeSupplierRepository.batchSelectActivityChangeSupplier(changeSupplierDO);
        }
    }


    public void extractedUser(DycActivityChangeDO reqBO, DycActivityDO activityDO, DycActivityChangeInfo changeInfo) {
        //用户
        List<DycActivityUserInfo> userInfos = dycActActivityUserRepository.queryActivityUserList(activityDO);
        if (!CollectionUtils.isEmpty(userInfos)) {
            DycActivityChangeDO changeDO = new DycActivityChangeDO();
            changeDO.setChangeId(changeInfo.getChangeId());
            changeDO.setCreateUserId(reqBO.getCreateUserId());
            changeDO.setCreateUserName(reqBO.getCreateUserName());
            List<DycActivityChangeUserInfo> collect = userInfos.stream().map(item -> {
                DycActivityChangeUserInfo changeUserInfo = new DycActivityChangeUserInfo();
                changeUserInfo.setUserId(item.getUserId());
                changeUserInfo.setBalanceScores(item.getBalanceScores());
                changeUserInfo.setEffMoney(item.getEffMoney());
                changeUserInfo.setGiveScores(item.getGiveScores());
                changeUserInfo.setLoseScores(item.getLoseScores());
                changeUserInfo.setName(item.getName());
                changeUserInfo.setPhone(item.getPhone());
                changeUserInfo.setScoresType(item.getScoresType());
                changeUserInfo.setSex(item.getSex());
                changeUserInfo.setUsedScores(item.getUsedScores());
                changeUserInfo.setUserName(item.getUserName());
                changeUserInfo.setUserOrgId(item.getUserOrgId());
                changeUserInfo.setUserOrgName(item.getUserOrgName());
                changeUserInfo.setWorkNo(item.getWorkNo());
                return changeUserInfo;
            }).collect(Collectors.toList());
            changeDO.setUserList(collect);
            dycActActivityChangeUserRepository.batchSelectActivityChangeUser(changeDO);
        }
    }


    public void extractedCatalog(DycActivityChangeDO reqBO, DycActivityChangeInfo changeInfo) {
        //商品类型
        DycActiveCommodityCatalogQueryBO catalogQueryBO = new DycActiveCommodityCatalogQueryBO();
        catalogQueryBO.setActivityId(reqBO.getActivityId());
        List<DycActiveCommodityCatalogInfo> catalogInfos = dycActActivityCommodityRepository.queryActiveCommodityCatalogAllList(catalogQueryBO);
        if (!CollectionUtils.isEmpty(catalogInfos)) {
            DycActivityChangeDO changeDO = new DycActivityChangeDO();
            changeDO.setChangeId(changeInfo.getChangeId());
            changeDO.setCreateUserId(reqBO.getCreateUserId());
            changeDO.setCreateUserName(reqBO.getCreateUserName());
            List<DycActivityChangeRelaCommodityCatalogInfo> collect = catalogInfos.stream().map(item -> {
                DycActivityChangeRelaCommodityCatalogInfo commodityCatalogInfo = new DycActivityChangeRelaCommodityCatalogInfo();
                commodityCatalogInfo.setCommodityPoolId(item.getCommodityPoolId());
                commodityCatalogInfo.setCommodityPoolName(item.getCommodityPoolName());
                commodityCatalogInfo.setCommodityTypeId(item.getCommodityTypeId());
                commodityCatalogInfo.setCommodityTypeName(item.getCommodityTypeName());
                commodityCatalogInfo.setFirstCatalogId(item.getFirstCatalogId());
                commodityCatalogInfo.setFirstCatalogName(item.getFirstCatalogName());
                commodityCatalogInfo.setSecondCatalogId(item.getSecondCatalogId());
                commodityCatalogInfo.setSecondCatalogName(item.getSecondCatalogName());
                commodityCatalogInfo.setThreeCatalogId(item.getThreeCatalogId());
                commodityCatalogInfo.setThreeCatalogName(item.getThreeCatalogName());
                return commodityCatalogInfo;
            }).collect(Collectors.toList());
            changeDO.setCommodityCatalogList(collect);
            dycActActivityChangeCommodityRepository.batchSelectActivityChangeCommodityCatalog(changeDO);
        }
    }


    public void extractedCommodity(DycActivityChangeDO reqBO, DycActivityDO activityDO, DycActivityChangeInfo changeInfo) {
        //商品
        List<DycActActivityRelaCommodityInfo> relaCommodityInfos = dycActActivityCommodityRepository.queryActivityCommodityList(activityDO);
        if (!CollectionUtils.isEmpty(relaCommodityInfos)) {
            DycActivityChangeDO changeDO = new DycActivityChangeDO();
            changeDO.setChangeId(changeInfo.getChangeId());
            changeDO.setCreateUserId(reqBO.getCreateUserId());
            changeDO.setCreateUserName(reqBO.getCreateUserName());
            List<DycActivityChangeRelaCommodityInfo> collect = relaCommodityInfos.stream().map(item -> {
                DycActivityChangeRelaCommodityInfo commodityInfo = new DycActivityChangeRelaCommodityInfo();
                commodityInfo.setCommodityPoolId(item.getCommodityPoolId());
                commodityInfo.setCommodityPoolName(item.getCommodityPoolName());
                commodityInfo.setCommodityTypeId(item.getCommodityTypeId());
                commodityInfo.setCommodityTypeName(item.getCommodityTypeName());
                commodityInfo.setSkuCode(item.getSkuCode());
                commodityInfo.setSkuDetails(item.getSkuDetails());
                commodityInfo.setSkuId(item.getSkuId());
                commodityInfo.setSkuName(item.getSkuName());
                return commodityInfo;
            }).collect(Collectors.toList());
            changeDO.setCommodityList(collect);
            dycActActivityChangeCommodityRepository.batchSelectActivityChangeCommodity(changeDO);
        }
    }


    public void extractedCommodityPool(DycActivityChangeDO reqBO, DycActivityChangeInfo changeInfo) {
        //商品池
        DycQueryActivityCommodityPoolPageListReqBO listReqBO = new DycQueryActivityCommodityPoolPageListReqBO();
        listReqBO.setActivityId(reqBO.getActivityId());
        List<DycActivityCommodityPoolInfo> commodityPoolInfos = dycActActivityCommodityRepository.queryActivityCommodityPoolList(listReqBO);
        if (!CollectionUtils.isEmpty(commodityPoolInfos)) {
            DycActivityChangeDO changeDO = new DycActivityChangeDO();
            changeDO.setChangeId(changeInfo.getChangeId());
            changeDO.setCreateUserId(reqBO.getCreateUserId());
            changeDO.setCreateUserName(reqBO.getCreateUserName());
            List<DycActivityChangeRelaCommodityPoolInfo> collect = commodityPoolInfos.stream().map(item -> {
                DycActivityChangeRelaCommodityPoolInfo relaCommodityPoolInfo = new DycActivityChangeRelaCommodityPoolInfo();
                relaCommodityPoolInfo.setCommodityPoolId(item.getCommodityPoolId());
                relaCommodityPoolInfo.setCommodityPoolName(item.getCommodityPoolName());
                relaCommodityPoolInfo.setApplyActivityType(item.getApplyActivityType());
                relaCommodityPoolInfo.setRelaCommodityAmount(item.getRelaCommodityAmount());
                relaCommodityPoolInfo.setRelaCatalogAmount(item.getRelaCatalogAmount());
                return relaCommodityPoolInfo;
            }).collect(Collectors.toList());
            changeDO.setCommodityPoolList(collect);
            dycActActivityChangeCommodityRepository.batchSelectActivityChangeCommodityPool(changeDO);
        }
    }

    @Override
    public BasePageRspBo<DycActivityChangeRelaCommodityCatalogInfo> queryActivityChangeSelectedCommodityCatalogPageList(DycActivityChangeDO reqBO) {
        return dycActActivityChangeCommodityRepository.queryActivityChangeSelectedCommodityCatalogPageList(reqBO);
    }

    @Override
    public int batchSelectActivityChangeCommodityCatalog(DycActivityChangeDO reqBO) {
        return dycActActivityChangeCommodityRepository.batchSelectActivityChangeCommodityCatalog(reqBO);
    }

    @Override
    public int batchRemoveActivityChangeCommodityCatalog(DycActivityChangeDO reqBO) {
        return dycActActivityChangeCommodityRepository.batchRemoveActivityChangeCommodityCatalog(reqBO);
    }

    @Override
    public BasePageRspBo<DycActivityChangeRelaCommodityInfo> queryActivityChangeCommodityPageList(DycActivityChangeDO reqBO) {
        return dycActActivityChangeCommodityRepository.queryActivityChangeCommodityPageList(reqBO);
    }

    @Override
    public int batchSelectActivityChangeUser(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getChangeId()) {
            throw new ZTBusinessException("变更单id不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getUserList())) {
            throw new ZTBusinessException("入参用户列表不能为空！");
        }
        return dycActActivityChangeUserRepository.batchSelectActivityChangeUser(reqBO);
    }

    @Override
    public int batchRemoveActivityChangeUser(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getChangeId()) {
            throw new ZTBusinessException("变更单id不能为空！");
        }
        if (CollectionUtils.isEmpty(reqBO.getUserIdList())) {
            throw new ZTBusinessException("用户列表不能为空！");
        }
        return dycActActivityChangeUserRepository.batchRemoveActivityChangeUser(reqBO);
    }

    @Override
    public int batchSelectActivityChangeCommodity(DycActivityChangeDO reqBO) {
        return dycActActivityChangeCommodityRepository.batchSelectActivityChangeCommodity(reqBO);
    }

    @Override
    public int batchRemoveActivityChangeCommodity(DycActivityChangeDO reqBO) {
        return dycActActivityChangeCommodityRepository.batchRemoveActivityChangeCommodity(reqBO);
    }

    @Override
    public DycActImportActivityUserModelRspBO importActivityChangeUser(DycActImportActivityUserModelReqBO reqBO) {
        DycActImportActivityUserModelRspBO rspBO = new DycActImportActivityUserModelRspBO();
        DycActImportActivityUserModelBO dycActImportActivityUserModelBO = new DycActImportActivityUserModelBO();
        List<DycActImportActivityUserInfoModelBO> list = new ArrayList<>();
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参为空");
        }
        JSONObject jsonObject = JSON.parseObject(reqBO.getRequestParam());
        if (!jsonObject.containsKey("changeId") || !jsonObject.containsKey("userId") || !jsonObject.containsKey("name")) {
            throw new ZTBusinessException("入参为空");
        }
        //得到活动id、操作人id、操作人名称
        String changeId = jsonObject.get("changeId").toString();
        String userId = jsonObject.get("userId").toString();
        String name = jsonObject.get("name").toString();
        if (StringUtils.isEmpty(changeId) || StringUtils.isEmpty(userId) || StringUtils.isEmpty(name)) {
            throw new ZTBusinessException("入参为空");
        }
        DycActivityChangeDO dycActivityChangeDO = new DycActivityChangeDO();
        dycActivityChangeDO.setChangeId(Long.valueOf(changeId));
        List<DycActivityChangeUserInfo> dycActivityChangeUserInfos = dycActActivityChangeUserRepository.queryChangeActivityUserList(dycActivityChangeDO);
        Set<Long> collect = dycActivityChangeUserInfos.stream().map(DycActivityChangeUserInfo::getUserId).collect(Collectors.toSet());
        //得到需要添加的用户
        JSONArray userItem = jsonObject.getJSONArray("userItem");
        if (userItem.size() < 1) {
            throw new ZTBusinessException("没有需要增加的用户");
        }
        for (Object o : userItem) {
            JSONObject json = JSON.parseObject(o.toString());
            DycActImportActivityUserInfoModelBO dycActImportActivityUserInfoModelBO = new DycActImportActivityUserInfoModelBO();
            if (collect.size() > 0 && collect.contains(Long.valueOf(json.get("userId").toString()))) {
                dycActImportActivityUserInfoModelBO.setLineNum(Long.valueOf(json.get("gluttonLineNum").toString()));
                dycActImportActivityUserInfoModelBO.setFailReason("活动变更用户已存在");
                list.add(dycActImportActivityUserInfoModelBO);
            } else {
//                DycActivityDO dycActivityUserInfo = new DycActivityDO();
                DycActivityChangeDO dycActivityUserInfo = JSON.parseObject(json.toString(), DycActivityChangeDO.class);
//                dycActivityUserInfo.setUserId(Long.valueOf(json.get("userId").toString()));
//                dycActivityUserInfo.setUserName(json.get("userName").toString());
//                dycActivityUserInfo.setName(json.get("name").toString());
//                dycActivityUserInfo.setWorkNo(json.get("workNo").toString());
//                dycActivityUserInfo.setUserOrgId(Long.valueOf(json.get("userOrgId").toString()));
//                dycActivityUserInfo.setUserOrgName(json.get("userOrgName").toString());
//                dycActivityUserInfo.setPhone(json.get("phone").toString());
                dycActivityUserInfo.setChangeId(Long.valueOf(changeId));
                dycActivityUserInfo.setCreateUserId(Long.valueOf(userId));
                dycActivityUserInfo.setCreateUserName(name);
                try {
                    dycActActivityChangeUserRepository.addChangeUser(dycActivityUserInfo);
                } catch (Exception e) {
                    dycActImportActivityUserInfoModelBO.setLineNum(Long.valueOf(json.get("gluttonLineNum").toString()));
                    dycActImportActivityUserInfoModelBO.setFailReason(e.getMessage());
                    list.add(dycActImportActivityUserInfoModelBO);
                }
            }

        }
        dycActImportActivityUserModelBO.setFailReasonList(list);
        rspBO.setData(dycActImportActivityUserModelBO);
        return rspBO;
    }

    @Override
    public int batchModifyActivityChangeUserScores(DycActivityChangeDO dycActivityChangeDO) {
        return dycActActivityChangeUserRepository.batchModifyActivityChangeUserScores(dycActivityChangeDO);
    }

    @Override
    public int modifyActivityChangeUserScores(DycActivityChangeDO dycActivityChangeDO) {
        return dycActActivityChangeUserRepository.batchModifyActivityChangeUserScores(dycActivityChangeDO);
    }

    @Override
    public DycActivityChangeInfo changeActivityChangeState(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getChangeId()) {
            throw new ZTBusinessException("变更单id不能为空！");
        }
        if (null == reqBO.getChangeState()) {
            throw new ZTBusinessException("变更单状态不能为空！");
        }
        return dycActActivityChangeRepository.changeActivityChangeState(reqBO);
    }

    @Override
    public BasePageRspBo<DycActivityChangeInfo> queryActivityChangePageList(DycActivityChangeDO reqBO) {
        return dycActActivityChangeRepository.queryActivityChangePageList(reqBO);
    }

    @Override
    public BasePageRspBo<DycActivityChangeUserInfo> queryActivityChangeUserPageList(DycActivityChangeDO reqBO) {
        if (ObjectUtils.isEmpty(reqBO)) {
            throw new ZTBusinessException("入参不能为空！");
        }
        if (null == reqBO.getChangeId()) {
            throw new ZTBusinessException("变更单id不能为空！");
        }
        return dycActActivityChangeUserRepository.queryActivityChangeUserPageList(reqBO);
    }
}
