package com.tydic.dyc.act.repository.api;


import com.tydic.dyc.act.model.bo.DycActActivityChangeApproveBaseInfo;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeInfo;
import com.tydic.dyc.act.model.bo.DycProcessDO;
import com.tydic.dyc.base.bo.BasePageRspBo;

/**
 * 描述: 〈活动变更实体基建方法〉
 * @author : yuhao
 * @date : 2023/12/12 15:27
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActActivityChangeRepository {

    /**
     * 描述:活动变更单基本信息查询服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeRspDO
     */
    DycActivityChangeInfo queryActivityChangeBaseInfo(DycActivityChangeDO reqBO);

    /**
     * 描述:变更单基本信息保存
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeInfo
     */
    DycActivityChangeInfo saveActiveChangeBaseInfo(DycActivityChangeDO reqBO);

    /**
     * 描述:活动变更状态变更服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeInfo
     */
    DycActivityChangeInfo changeActivityChangeState(DycActivityChangeDO reqBO);

    /**
     * 活动变更列表查询（分页）服务
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActivityChangeInfo> queryActivityChangePageList(DycActivityChangeDO reqBO);

    /**
     *
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActActivityChangeApproveBaseInfo> queryActivityChangeApprovePageList(DycProcessDO reqBO);
}
