package com.tydic.dyc.act.repository.api;


import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeUserInfo;
import com.tydic.dyc.base.bo.BasePageRspBo;

import java.util.List;

/**
 * 描述: 〈活动变更用户基建方法〉
 * @author : yuhao
 * @date : 2023/12/12 15:29
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActActivityChangeUserRepository {
    /**
     * 描述:活动用户变更选择（批量）
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeUserInfo
     */
    int batchSelectActivityChangeUser(DycActivityChangeDO reqBO);

    /**
     * 描述:活动变更已选用户列表查询（分页）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityChangeUserInfo
     */
    BasePageRspBo<DycActivityChangeUserInfo> queryActivityChangeUserPageList(DycActivityChangeDO reqBO);
    /**
     * 描述:活动变更用户移除（批量）服务
     *
     * @param reqBO
     * @return int
     */
    int batchRemoveActivityChangeUser(DycActivityChangeDO reqBO);

    /**
     * 根据变更单id查询用户
     * @param dycActivityChangeDO
     * @return
     */
    List<DycActivityChangeUserInfo> queryChangeActivityUserList(DycActivityChangeDO dycActivityChangeDO);

    /**
     * 变更用户新增
     * @param dycActivityUserInfo
     */
    int addChangeUser(DycActivityChangeDO dycActivityUserInfo);

    /**
     * 活动变更用户积分修改（批量）服务
     * @param dycActivityChangeDO
     * @return
     */
    int batchModifyActivityChangeUserScores(DycActivityChangeDO dycActivityChangeDO);
}
