package com.tydic.dyc.act.repository.api;

import com.tydic.dyc.act.model.bo.DycActActivityRelaCommodityInfo;
import com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo;
import com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogQueryBO;
import com.tydic.dyc.act.model.bo.DycActivityCommodityPoolInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycQueryActivityCommodityPoolPageListReqBO;
import com.tydic.dyc.base.bo.BasePageRspBo;

import java.util.List;

/**
 * 描述: 〈活动商品基建方法〉
 * @author : yuhao
 * @date : 2023/12/12 15:28
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActActivityCommodityRepository {

    /**
     * 描述:活动已选商品池列表分页查询
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityCommodityPoolInfo
     */
    BasePageRspBo<DycActivityCommodityPoolInfo> queryActivityCommodityPoolPageList(DycQueryActivityCommodityPoolPageListReqBO reqBO);

    /**
     * 描述:活动已选商品池列表查询
     *
     * @param reqBO
     * @return java.util.List<com.tydic.dyc.act.model.bo.DycActivityCommodityPoolInfo>
     */
    List<DycActivityCommodityPoolInfo> queryActivityCommodityPoolList(DycQueryActivityCommodityPoolPageListReqBO reqBO);

    /**
     * 活动已选商品列表分页查询
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActActivityRelaCommodityInfo> queryActivityCommodityPageList(DycActivityDO reqBO);

    /**
     * 描述:活动已选商品列表查询
     *
     * @param reqBO
     * @return java.util.List<com.tydic.dyc.act.model.bo.DycActActivityRelaCommodityInfo>
     */
    List<DycActActivityRelaCommodityInfo> queryActivityCommodityList(DycActivityDO reqBO);
    /**
     * 描述:活动已选商品类型列表分页查询
     *
     * @param reqBO
     * @return com.tydic.dyc.base.bo.BasePageRspBo<com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo>
     */
    BasePageRspBo<DycActiveCommodityCatalogInfo> queryActiveCommodityCatalogList(DycActiveCommodityCatalogQueryBO reqBO);

    /**
     * 描述:活动已选商品类型列表查询
     *
     * @param reqBO
     * @return java.util.List<com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo>
     */
    List<DycActiveCommodityCatalogInfo> queryActiveCommodityCatalogAllList(DycActiveCommodityCatalogQueryBO reqBO);
    /**
     * 描述:活动商品池选择（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityCommodityPoolInfo
     */
    DycActivityCommodityPoolInfo batchSelectActivityCommodityPool(DycActivityDO reqBO);

    /**
     * 活动商品池移除（批量）服务
     * @param reqBO
     * @return
     */
    int batchRemoveActivityCommodityPool(DycActivityDO reqBO);

    /**
     * 描述:活动商品类型选择（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo
     */
    DycActiveCommodityCatalogInfo batchSelectActivityCommodityCatalog(DycActivityDO reqBO);

    /**
     *活动商品类型移除（批量）服务
     * @param reqBO
     * @return
     */
    int batchRemoveActivityCommodityCatalog(DycActivityDO reqBO);

    /**
     * 描述:活动商品选择（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActActivityRelaCommodityInfo
     */
    DycActActivityRelaCommodityInfo batchSelectActivityCommodity(DycActivityDO reqBO);

    /**
     * 活动商品移除（批量）服务
     * @param reqBO
     * @return
     */
    int batchRemoveActivityCommodity(DycActivityDO reqBO);
}
