package com.tydic.dyc.act.repository.api;

import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycActivitySupplierInfo;
import com.tydic.dyc.act.model.bo.DycActivitySupplierInfoAddBatchBO;
import com.tydic.dyc.act.model.bo.DycActivitySupplierInfoDeleteBatchBO;
import com.tydic.dyc.base.bo.BasePageRspBo;

import java.util.List;

/**
 * 描述: 〈活动供应商基建方法〉
 * @author : yuhao
 * @date : 2023/12/12 15:30
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActActivitySupplierRepository {
    /**
     * 描述: 可选供应商批量查询
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivitySupplierInfo
     */
    BasePageRspBo<DycActivitySupplierInfo> queryActivityUnselectSupplierPageList(DycActivityDO reqBO);
    /**
     * 描述: 供应商批量更新
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivitySupplierInfo
     */
    DycActivitySupplierInfo addBatchActiveSupplier(DycActivitySupplierInfoAddBatchBO reqBO);
    /**
     * 描述: 供应商批量删除
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivitySupplierInfo
     */
    DycActivitySupplierInfo deleteBatchActiveSupplier(DycActivitySupplierInfoDeleteBatchBO reqBO);
    /**
     * 描述: 已选供应商批量查询
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivitySupplierInfo
     */
    BasePageRspBo<DycActivitySupplierInfo> queryActiveSupplierList(DycActivityDO reqBO);

    List<DycActivitySupplierInfo> queryActiveSupplierAllList(DycActivityDO reqBO);
}
