package com.tydic.dyc.act.repository.api;

import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycActivityUserInfo;
import com.tydic.dyc.act.model.bo.DycActivityUserScoresUseRecordInfo;
import com.tydic.dyc.base.bo.BasePageRspBo;

import java.util.List;

/**
 * 描述: 〈活动用户基建方法〉
 * @author : yuhao
 * @date : 2023/12/12 15:29
 * 注意：本内容仅限于北京天源迪科信息技术有限公司内部传阅，禁止外泄以及用于其他的商业目的
 */
public interface DycActActivityUserRepository {
    /**
     * 活动已选用户列表分页查询服务
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActivityUserInfo> queryActivityUserPageList(DycActivityDO reqBO);
    /**
     * 活动已选用户列表查询服务
     * @param reqBO
     * @return
     */
    List<DycActivityUserInfo> queryActivityUserList(DycActivityDO reqBO);
    /**
     * 活动用户新增
     * @param reqBO
     * @return
     */
    int addUser(DycActivityDO reqBO);
    /**
     * 描述:活动用户选择（批量）
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityUserInfo
     */
    DycActivityUserInfo batchSelectActivityUser(DycActivityDO reqBO);
    /**
     * 描述:活动用户移除（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityUserInfo
     */
    DycActivityUserInfo batchRemoveActivityUser(DycActivityDO reqBO);
    /**
     * 描述:活跃用户积分修改服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityUserInfo
     */
    DycActivityUserInfo modifyActivityUserScores(DycActivityDO reqBO);

    /**
     * 描述:活动用户积分修改（批量）服务
     *
     * @param reqBO
     * @return com.tydic.dyc.act.model.bo.DycActivityUserInfo
     */
    DycActivityUserInfo batchModifyActivityUserScores(DycActivityDO reqBO);

    /**
     * 活动用户积分流水查询（分页）服务
     * @param reqBO
     * @return
     */
    BasePageRspBo<DycActivityUserScoresUseRecordInfo> queryActivityUserScoresUseRecordPageList(DycActivityDO reqBO);

    /**
     * 活动积分扣减/退还服务
     * @param reqBO
     * @return
     */
    int deductOrReturnActivityScores(DycActivityDO reqBO);
}
