package com.tydic.dyc.act.service.impl;

import cn.hutool.core.util.ObjectUtil;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityBaseInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycActivityFileInfo;
import com.tydic.dyc.act.service.api.DycActActiveBaseInfoQueryService;
import com.tydic.dyc.act.service.bo.DycActActiveBaseDetailInfoBO;
import com.tydic.dyc.act.service.bo.DycActActiveBaseInfoQueryReqBO;
import com.tydic.dyc.act.service.bo.DycActActiveBaseInfoQueryRspBO;
import com.tydic.dyc.act.service.bo.DycActActiveFileInfoBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;

import java.util.ArrayList;
import java.util.List;

/**
 * 标题：DycActActiveBaseInfoQueryService
 * 说明：活动基本信息详情查询
 * 时间： 2023-12-12 11:12
 * 作者 @author zhoulu
 */

@HTServiceImpl
public class DycActActiveBaseInfoQueryServiceImpl implements DycActActiveBaseInfoQueryService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActActiveBaseInfoQueryRspBO queryActiveBaseInfo(DycActActiveBaseInfoQueryReqBO reqBO) {
        DycActActiveBaseInfoQueryRspBO rspBO = new DycActActiveBaseInfoQueryRspBO();
        if (ObjectUtil.isEmpty(reqBO.getActivityId())) {
            throw new ZTBusinessException("活动id不能为空");
        }
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActivityDO.setActivityId(reqBO.getActivityId());
        List<DycActivityBaseInfo> dycActivityBaseInfos = dycActActivityModel.queryActivityList(dycActivityDO);
        List<DycActivityFileInfo> dycActivityFileInfos = dycActActivityModel.queryActivityFileList(dycActivityDO);

        DycActActiveBaseDetailInfoBO activityBaseDetail = new DycActActiveBaseDetailInfoBO();
        List<DycActActiveFileInfoBO> activityFileList = new ArrayList<>();
        if (dycActivityBaseInfos.size() > 0) {
            BeanUtils.copyProperties(dycActivityBaseInfos.get(0), activityBaseDetail);
        }
        if (dycActivityFileInfos.size() > 0) {
            for (DycActivityFileInfo dycActivityFileInfo : dycActivityFileInfos) {
                DycActActiveFileInfoBO bo = new DycActActiveFileInfoBO();
                BeanUtils.copyProperties(dycActivityFileInfo, bo);
                activityFileList.add(bo);
            }
        }
        rspBO.setActivityBaseDetail(activityBaseDetail);
        rspBO.setActivityFileList(activityFileList);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
