package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityBaseInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActActiveListQueryService;
import com.tydic.dyc.act.service.bo.DycActivityReqBO;
import com.tydic.dyc.act.service.bo.DycActivityRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActActiveListQueryServiceImpl
 * 说明：活动列表查询服务
 * 时间： 2023-12-12 16:15
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActActiveListQueryServiceImpl implements DycActActiveListQueryService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActivityRspBO qryActivePageList(DycActivityReqBO reqBO) {
        DycActivityDO queryBO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        BasePageRspBo<DycActivityBaseInfo> basePageRspBo = dycActActivityModel.queryActivityPageList(queryBO);
        DycActivityRspBO rspBO = JSON.parseObject(JSON.toJSONString(basePageRspBo), DycActivityRspBO.class);
        return rspBO;
    }
}
