package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActActiveSupplierListPageQueryService;
import com.tydic.dyc.act.service.bo.DycActActiveSupplierListPageQueryReqBO;
import com.tydic.dyc.act.service.bo.DycActActiveSupplierListPageQueryRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActActiveBaseInfoQueryService
 * 说明：活动已选供应商列表分页查询服务
 * 时间： 2023-12-12 11:12
 * 作者 @author zhoulu
 */
@HTServiceImpl
public class DycActActiveSupplierListPageQueryServiceImpl implements DycActActiveSupplierListPageQueryService {
    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActActiveSupplierListPageQueryRspBO queryActiveSupplierList(DycActActiveSupplierListPageQueryReqBO reqBO) {
        if (reqBO.getActivityId() == null) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActivityDO.setActivityId(reqBO.getActivityId());
        return JSON.parseObject(JSON.toJSONString(dycActActivityModel.queryActiveSupplierList(dycActivityDO)), DycActActiveSupplierListPageQueryRspBO.class);
    }
}
