package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.service.api.DycActBatchModifyActivityChangeUserScoresService;
import com.tydic.dyc.act.service.bo.DycActBatchModifyActivityChangeUserScoresReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchModifyActivityChangeUserScoresRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

/**
 * 说明：活动变更用户积分修改（批量）服务
 *
 * @author zhoulu
 * @date 2023年12月26日 16:27
 */
@HTServiceImpl
public class DycActBatchModifyActivityChangeUserScoresServiceImpl implements DycActBatchModifyActivityChangeUserScoresService {
    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActBatchModifyActivityChangeUserScoresRspBO batchModifyActivityChangeUserScores(DycActBatchModifyActivityChangeUserScoresReqBO reqBO) {
        if (reqBO.getChangeId() == null) {
            throw new ZTBusinessException("变更单id不能为空!");
        }
        if (reqBO.getGiveScores() == null) {
            throw new ZTBusinessException("发放积分不能为空不能为空!");
        }
        if (reqBO.getUserId() == null) {
            throw new ZTBusinessException("操作人Id不能为空!");
        }
        if (StringUtils.isEmpty(reqBO.getName())) {
            throw new ZTBusinessException("操作人名称不能为空!");
        }
        DycActivityChangeDO dycActivityChangeDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityChangeDO.class);
        dycActivityChangeDO.setUpdateUserId(reqBO.getUserId());
        dycActivityChangeDO.setUpdateUserName(reqBO.getName());
        dycActivityChangeDO.setUserId(null);
        dycActivityChangeModel.batchModifyActivityChangeUserScores(dycActivityChangeDO);
        DycActBatchModifyActivityChangeUserScoresRspBO rspBO = new DycActBatchModifyActivityChangeUserScoresRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
