package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.service.api.DycActBatchRemoveActivityChangeCommodityCatalogService;
import com.tydic.dyc.act.service.bo.DycActBatchRemoveActivityChangeCommodityCatalogReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchRemoveActivityChangeCommodityCatalogRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

/**
 * 说明：活动变更商品类型移除（批量）服务
 *
 * @author zhoulu
 * @date 2023年12月25日 16:29
 */
@HTServiceImpl
public class DycActBatchRemoveActivityChangeCommodityCatalogServiceImpl implements DycActBatchRemoveActivityChangeCommodityCatalogService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActBatchRemoveActivityChangeCommodityCatalogRspBO batchRemoveActivityChangeCommodityCatalog(DycActBatchRemoveActivityChangeCommodityCatalogReqBO reqBO) {
        if (reqBO.getChangeId() == null) {
            throw new ZTBusinessException("变更单id不能为空!");
        }
        if (reqBO.getCommodityTypeIdList().size() < 1) {
            throw new ZTBusinessException("商品类型id列表不能为空!");
        }
        if (reqBO.getUserId() == null) {
            throw new ZTBusinessException("操作人Id不能为空!");
        }
        if (StringUtils.isEmpty(reqBO.getName())) {
            throw new ZTBusinessException("操作人名称不能为空!");
        }
        DycActivityChangeDO dycActivityChangeDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityChangeDO.class);
        dycActivityChangeDO.setUpdateUserId(reqBO.getUserId());
        dycActivityChangeDO.setUpdateUserName(reqBO.getName());
        dycActivityChangeModel.batchRemoveActivityChangeCommodityCatalog(dycActivityChangeDO);
        DycActBatchRemoveActivityChangeCommodityCatalogRspBO rspBO = new DycActBatchRemoveActivityChangeCommodityCatalogRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
