package com.tydic.dyc.act.service.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActBatchRemoveActivityCommodityCatalogService;
import com.tydic.dyc.act.service.bo.DycActBatchRemoveActivityCommodityCatalogReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchRemoveActivityCommodityCatalogRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 说明：活动商品类型移除（批量）服务
 *
 * @author zhoulu
 * @date 2023年12月15日 10:35
 */
@HTServiceImpl
public class DycActBatchRemoveActivityCommodityCatalogServiceImpl implements DycActBatchRemoveActivityCommodityCatalogService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActBatchRemoveActivityCommodityCatalogRspBO batchRemoveActivityCommodityCatalog(DycActBatchRemoveActivityCommodityCatalogReqBO reqBO) {
        if (reqBO.getActivityId() == null) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        if (reqBO.getCommodityTypeIdList().size() < 1) {
            throw new ZTBusinessException("商品类型id不能为空！");
        }
        if (StringUtils.isEmpty(reqBO.getUpdateUserName())) {
            throw new ZTBusinessException("更新人名称不能为空！");
        }
        if (reqBO.getUpdateUserId() == null) {
            throw new ZTBusinessException("更新人id不能为空！");
        }
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActivityDO.setActivityId(reqBO.getActivityId());
        dycActivityDO.setCommodityTypeIdList(reqBO.getCommodityTypeIdList());
        dycActivityDO.setUpdateUserName(reqBO.getUpdateUserName());
        dycActivityDO.setUpdateUserId(reqBO.getUpdateUserId());
        dycActActivityModel.batchRemoveActivityCommodityCatalog(dycActivityDO);
        DycActBatchRemoveActivityCommodityCatalogRspBO rspBO = new DycActBatchRemoveActivityCommodityCatalogRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
