package com.tydic.dyc.act.service.impl;

import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActBatchRemoveActivityCommodityPoolService;
import com.tydic.dyc.act.service.bo.DycActBatchRemoveActivityCommodityPoolReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchRemoveActivityCommodityPoolRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 说明：
 *
 * @author zhoulu
 * @date 2023年12月14日 14:32
 */
@HTServiceImpl
public class DycActBatchRemoveActivityCommodityPoolServiceImpl implements DycActBatchRemoveActivityCommodityPoolService {
    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActBatchRemoveActivityCommodityPoolRspBO batchRemoveActivityCommodityPool(DycActBatchRemoveActivityCommodityPoolReqBO reqBO) {
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActivityDO.setActivityId(reqBO.getActivityId());
        dycActivityDO.setUpdateUserId(reqBO.getUpdateUserId());
        dycActivityDO.setUpdateUserName(reqBO.getUpdateUserName());
        dycActivityDO.setCommodityPoolIdList(reqBO.getCommodityPoolIdList());
        dycActActivityModel.batchRemoveActivityCommodityPool(dycActivityDO);
        DycActBatchRemoveActivityCommodityPoolRspBO rspBO = new DycActBatchRemoveActivityCommodityPoolRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
