package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActBatchRemoveActivityCommodityService;
import com.tydic.dyc.act.service.bo.DycActBatchRemoveActivityCommodityReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchRemoveActivityCommodityRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 说明：活动商品移除（批量）服务
 *
 * @author zhoulu
 * @date 2023年12月18日 11:33
 */
@HTServiceImpl
public class DycActBatchRemoveActivityCommodityServiceImpl implements DycActBatchRemoveActivityCommodityService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActBatchRemoveActivityCommodityRspBO batchRemoveActivityCommodity(DycActBatchRemoveActivityCommodityReqBO reqBO) {
        if (reqBO.getActivityId() == null) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        if (reqBO.getSkuIdList().size() < 1) {
            throw new ZTBusinessException("商品id不能为空！");
        }
        if (StringUtils.isEmpty(reqBO.getUpdateUserName())) {
            throw new ZTBusinessException("更新人名称不能为空！");
        }
        if (reqBO.getUpdateUserId() == null) {
            throw new ZTBusinessException("更新人id不能为空！");
        }
        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        dycActActivityModel.batchRemoveActivityCommodity(dycActivityDO);
        DycActBatchRemoveActivityCommodityRspBO rspBO = new DycActBatchRemoveActivityCommodityRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
