package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivitySupplierInfo;
import com.tydic.dyc.act.model.bo.DycActivitySupplierInfoDeleteBatchBO;
import com.tydic.dyc.act.service.api.DycActBatchRemoveActivitySupplierService;
import com.tydic.dyc.act.service.bo.DycActBatchRemoveActivitySupplierReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchRemoveActivitySupplierRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActBatchRemoveActivitySupplierServiceImpl
 * 说明：活动供应商移除（批量）服务
 * 时间： 2023-12-18 16:09
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActBatchRemoveActivitySupplierServiceImpl implements DycActBatchRemoveActivitySupplierService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActBatchRemoveActivitySupplierRspBO batchRemoveActivitySupplier(DycActBatchRemoveActivitySupplierReqBO reqBO) {

        DycActivitySupplierInfoDeleteBatchBO infoDeleteBatchBO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivitySupplierInfoDeleteBatchBO.class);

        DycActivitySupplierInfo activitySupplierInfo = dycActActivityModel.deleteBatchActiveSupplier(infoDeleteBatchBO);

        DycActBatchRemoveActivitySupplierRspBO rspBO = JSON.parseObject(JSON.toJSONString(activitySupplierInfo), DycActBatchRemoveActivitySupplierRspBO.class);

        return rspBO;
    }
}
