package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActBatchSelectActiveCommodityCatalogService;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityCommodityCatalogReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityCommodityCatalogRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActBatchSelectActiveCommodityCatalogServiceImpl
 * 说明：
 * 时间： 2023-12-15 10:22
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActBatchSelectActiveCommodityCatalogServiceImpl implements DycActBatchSelectActiveCommodityCatalogService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActBatchSelectActivityCommodityCatalogRspBO batchSelectActivityCommodityCatalog(DycActBatchSelectActivityCommodityCatalogReqBO reqBO) {


        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);

        DycActiveCommodityCatalogInfo catalogInfo = dycActActivityModel.batchSelectActivityCommodityCatalog(dycActivityDO);

        DycActBatchSelectActivityCommodityCatalogRspBO rspBO = JSON.parseObject(JSON.toJSONString(catalogInfo), DycActBatchSelectActivityCommodityCatalogRspBO.class);

        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);

        return rspBO;
    }
}
