package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.service.api.DycActBatchSelectActivityChangeUserService;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityChangeUserReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityChangeUserRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActBatchSelectActivityChangeUserServiceImpl
 * 说明：活动变更用户选择（批量）服务
 * 时间： 2023-12-26 14:17
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActBatchSelectActivityChangeUserServiceImpl implements DycActBatchSelectActivityChangeUserService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActBatchSelectActivityChangeUserRspBO batchSelectActivityChangeUser(DycActBatchSelectActivityChangeUserReqBO reqBO) {

        DycActivityChangeDO activityChangeDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityChangeDO.class);
        dycActivityChangeModel.batchSelectActivityChangeUser(activityChangeDO);
        DycActBatchSelectActivityChangeUserRspBO rspBO = new DycActBatchSelectActivityChangeUserRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
