package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityCommodityPoolInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActBatchSelectActivityCommodityPoolService;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityCommodityPoolReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityCommodityPoolRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActBatchSelectActivityCommodityPoolServiceImpl
 * 说明：活动商品池选择（批量）服务
 * 时间： 2023-12-14 14:29
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActBatchSelectActivityCommodityPoolServiceImpl implements DycActBatchSelectActivityCommodityPoolService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActBatchSelectActivityCommodityPoolRspBO batchSelectActivityCommodityPool(DycActBatchSelectActivityCommodityPoolReqBO reqBO) {

        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);

        DycActivityCommodityPoolInfo commodityPool = dycActActivityModel.batchSelectActivityCommodityPool(dycActivityDO);

        DycActBatchSelectActivityCommodityPoolRspBO rspBO = JSON.parseObject(JSON.toJSONString(commodityPool), DycActBatchSelectActivityCommodityPoolRspBO.class);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
