package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivitySupplierInfo;
import com.tydic.dyc.act.model.bo.DycActivitySupplierInfoAddBatchBO;
import com.tydic.dyc.act.service.api.DycActBatchSelectActivitySupplierService;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivitySupplierReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivitySupplierRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActBatchSelectActivitySupplierServiceImpl
 * 说明：活动供应商选择（批量）服务
 * 时间： 2023-12-18 16:43
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActBatchSelectActivitySupplierServiceImpl implements DycActBatchSelectActivitySupplierService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActBatchSelectActivitySupplierRspBO batchSelectActivitySupplier(DycActBatchSelectActivitySupplierReqBO reqBO) {

        DycActivitySupplierInfoAddBatchBO infoAddBatchBO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivitySupplierInfoAddBatchBO.class);

        DycActivitySupplierInfo supplierInfo = dycActActivityModel.addBatchActiveSupplier(infoAddBatchBO);

        DycActBatchSelectActivitySupplierRspBO rspBO = JSON.parseObject(JSON.toJSONString(supplierInfo), DycActBatchSelectActivitySupplierRspBO.class);

        return rspBO;
    }
}
