package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycActivityUserInfo;
import com.tydic.dyc.act.service.api.DycActBatchSelectActivityUserService;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityUserReqBO;
import com.tydic.dyc.act.service.bo.DycActBatchSelectActivityUserRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActBatchSelectActivityUserServiceImpl
 * 说明：活动用户选择（批量）
 * 时间： 2023-12-20 10:03
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActBatchSelectActivityUserServiceImpl implements DycActBatchSelectActivityUserService {


    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActBatchSelectActivityUserRspBO batchSelectActivityUser(DycActBatchSelectActivityUserReqBO reqBO) {

        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        DycActivityUserInfo activityUserInfo = dycActActivityModel.batchSelectActivityUser(dycActivityDO);
        DycActBatchSelectActivityUserRspBO rspBO = new DycActBatchSelectActivityUserRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
