package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeInfo;
import com.tydic.dyc.act.service.api.DycActChangeActivityChangeStateService;
import com.tydic.dyc.act.service.bo.DycActChangeActivityChangeStateReqBO;
import com.tydic.dyc.act.service.bo.DycActChangeActivityChangeStateRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActChangeActivityChangeStateServiceImpl
 * 说明：活动变更状态变更服务
 * 时间： 2023-12-27 15:13
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActChangeActivityChangeStateServiceImpl implements DycActChangeActivityChangeStateService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActChangeActivityChangeStateRspBO changeActivityChangeState(DycActChangeActivityChangeStateReqBO reqBO) {

        DycActivityChangeDO changeDO = new DycActivityChangeDO();
        changeDO.setChangeId(reqBO.getChangeId());
        changeDO.setChangeState(reqBO.getOperType());
        changeDO.setUpdateUserId(reqBO.getUserId());
        changeDO.setUpdateUserName(reqBO.getName());
        DycActivityChangeInfo dycActivityChangeInfo = dycActivityChangeModel.changeActivityChangeState(changeDO);
        return JSON.parseObject(JSON.toJSONString(dycActivityChangeInfo), DycActChangeActivityChangeStateRspBO.class);
    }
}
