package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeInfo;
import com.tydic.dyc.act.service.api.DycActChangeActivityService;
import com.tydic.dyc.act.service.bo.DycActChangeActivityReqBO;
import com.tydic.dyc.act.service.bo.DycActChangeActivityRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActChangeActivityService
 * 说明：活动变更服务
 * 时间： 2023-12-22 17:06
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActChangeActivityServiceImpl implements DycActChangeActivityService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;


    @Override
    public DycActChangeActivityRspBO changeActivity(DycActChangeActivityReqBO reqBO) {

        DycActivityChangeDO dycActivityChangeDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityChangeDO.class);
        DycActivityChangeInfo dycActivityChangeInfo = dycActivityChangeModel.changeActivity(dycActivityChangeDO);
        DycActChangeActivityRspBO rspBO = JSON.parseObject(JSON.toJSONString(dycActivityChangeInfo), DycActChangeActivityRspBO.class);
        return rspBO;
    }
}
