package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityBaseInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActCopyActivityService;
import com.tydic.dyc.act.service.bo.DycActCopyActivityReqBO;
import com.tydic.dyc.act.service.bo.DycActCopyActivityRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActCopyActivityServiceImpl
 * 说明：活动复制服务
 * 时间： 2023-12-19 14:24
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActCopyActivityServiceImpl implements DycActCopyActivityService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActCopyActivityRspBO copyActivity(DycActCopyActivityReqBO reqBO) {

        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);

        DycActivityBaseInfo baseInfo = dycActActivityModel.copyActivity(dycActivityDO);

        DycActCopyActivityRspBO rspBO = JSON.parseObject(JSON.toJSONString(baseInfo), DycActCopyActivityRspBO.class);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
