package com.tydic.dyc.act.service.impl;

import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActDeleteActivityService;
import com.tydic.dyc.act.service.bo.DycActDeleteActivityReqBO;
import com.tydic.dyc.act.service.bo.DycActDeleteActivityRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.util.StringUtils;

/**
 * 说明：活动删除服务
 *
 * @author zhoulu
 * @date 2023年12月19日 14:39
 */
@HTServiceImpl
public class DycActDeleteActivityServiceImpl implements DycActDeleteActivityService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActDeleteActivityRspBO deleteActivity(DycActDeleteActivityReqBO reqBO) {
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        if (null == reqBO.getUserId()) {
            throw new ZTBusinessException("操作人id不能为空！");
        }
        if (StringUtils.isEmpty(reqBO.getName())) {
            throw new ZTBusinessException("操作人名称不能为空！");
        }
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActivityDO.setActivityId(reqBO.getActivityId());
        dycActivityDO.setUpdateUserId(reqBO.getUserId());
        dycActivityDO.setUpdateUserName(reqBO.getName());
        dycActActivityModel.deleteActivity(dycActivityDO);
        DycActDeleteActivityRspBO rspBO = new DycActDeleteActivityRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
