package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActProcessModel;
import com.tydic.dyc.act.model.bo.DycProcessDO;
import com.tydic.dyc.act.service.api.DycActFlowInstanceSaveService;
import com.tydic.dyc.act.service.bo.DycActFlowInstanceSaveReqBO;
import com.tydic.dyc.act.service.bo.DycActFlowInstanceSaveRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActFlowInstanceSaveServiceImpl
 * 说明：流程实例表添加服务
 * 时间： 2023-12-29 14:32
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActFlowInstanceSaveServiceImpl implements DycActFlowInstanceSaveService {

    @Autowired
    private DycActProcessModel dycActProcessModel;

    @Override
    public DycActFlowInstanceSaveRspBO addActivityFlowInstance(DycActFlowInstanceSaveReqBO reqBO) {

        DycProcessDO dycProcessDO = JSON.parseObject(JSON.toJSONString(reqBO), DycProcessDO.class);
        dycActProcessModel.addActivityFlowInstance(dycProcessDO);
        DycActFlowInstanceSaveRspBO rspBO = new DycActFlowInstanceSaveRspBO();
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
