package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActImportActivityUserModelReqBO;
import com.tydic.dyc.act.model.bo.DycActImportActivityUserModelRspBO;
import com.tydic.dyc.act.service.api.DycActImportActivityChangeUserService;
import com.tydic.dyc.act.service.bo.DycActImportActivityChangeUserReqBO;
import com.tydic.dyc.act.service.bo.DycActImportActivityChangeUserRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 说明：活动变更用户导入服务
 *
 * @author zhoulu
 * @date 2023年12月26日 15:29
 */
@HTServiceImpl
public class DycActImportActivityChangeUserServiceImpl implements DycActImportActivityChangeUserService {
    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActImportActivityChangeUserRspBO importActivityChangeUser(DycActImportActivityChangeUserReqBO reqBO) {
        DycActImportActivityUserModelReqBO dycActImportActivityUserModelReqBO = JSON.parseObject(JSON.toJSONString(reqBO), DycActImportActivityUserModelReqBO.class);
        DycActImportActivityUserModelRspBO dycActImportActivityUserModelRspBO = dycActivityChangeModel.importActivityChangeUser(dycActImportActivityUserModelReqBO);
        DycActImportActivityChangeUserRspBO rspBO = JSON.parseObject(JSON.toJSONString(dycActImportActivityUserModelRspBO), DycActImportActivityChangeUserRspBO.class);
        return rspBO;
    }
}
