package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActImportActivityUserModelReqBO;
import com.tydic.dyc.act.model.bo.DycActImportActivityUserModelRspBO;
import com.tydic.dyc.act.service.api.DycActImportActivityUserService;
import com.tydic.dyc.act.service.bo.DycActImportActivityUserReqBO;
import com.tydic.dyc.act.service.bo.DycActImportActivityUserRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 说明：活动用户导入服务
 *
 * @author zhoulu
 * @date 2023年12月20日 14:36
 */
@HTServiceImpl
public class DycActImportActivityUserServiceImpl implements DycActImportActivityUserService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActImportActivityUserRspBO importActivityUser(DycActImportActivityUserReqBO reqBO) {
        DycActImportActivityUserModelReqBO dycActImportActivityUserModelReqBO = JSON.parseObject(JSON.toJSONString(reqBO), DycActImportActivityUserModelReqBO.class);
        DycActImportActivityUserModelRspBO dycActImportActivityUserModelRspBO = dycActActivityModel.importActivityUser(dycActImportActivityUserModelReqBO);
        DycActImportActivityUserRspBO rspBO = JSON.parseObject(JSON.toJSONString(dycActImportActivityUserModelRspBO), DycActImportActivityUserRspBO.class);
        return rspBO;
    }
}
