package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycActivityUserInfo;
import com.tydic.dyc.act.service.api.DycActModifyActivityUserScoresService;
import com.tydic.dyc.act.service.bo.DycActModifyActivityUserScoresReqBO;
import com.tydic.dyc.act.service.bo.DycActModifyActivityUserScoresRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActModifyActivityUserScoresServiceImpl
 * 说明：活跃用户积分修改服务
 * 时间： 2023-12-20 14:11
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActModifyActivityUserScoresServiceImpl implements DycActModifyActivityUserScoresService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActModifyActivityUserScoresRspBO modifyActivityUserScores(DycActModifyActivityUserScoresReqBO reqBO) {
        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        DycActivityUserInfo userInfo = dycActActivityModel.modifyActivityUserScores(dycActivityDO);
        DycActModifyActivityUserScoresRspBO rspBO = JSON.parseObject(JSON.toJSONString(userInfo), DycActModifyActivityUserScoresRspBO.class);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
