package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActProcessModel;
import com.tydic.dyc.act.model.bo.DycActActivityChangeApproveBaseInfo;
import com.tydic.dyc.act.model.bo.DycProcessDO;
import com.tydic.dyc.act.service.api.DycActQueryActivityChangeApprovePageListService;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangeApprovePageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangeApprovePageListRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 说明：活动变更审批列表查询（分页）服务
 *
 * @author zhoulu
 * @date 2023年12月28日 15:44
 */
@HTServiceImpl
public class DycActQueryActivityChangeApprovePageListServiceImpl implements DycActQueryActivityChangeApprovePageListService {
    @Autowired
    private DycActProcessModel dycActProcessModel;

    @Override
    public DycActQueryActivityChangeApprovePageListRspBO queryActivityChangeApprovePageList(DycActQueryActivityChangeApprovePageListReqBO reqBO) {
        DycProcessDO dycProcessDO = JSON.parseObject(JSON.toJSONString(reqBO), DycProcessDO.class);
        BasePageRspBo<DycActActivityChangeApproveBaseInfo> dycActActivityApproveBaseInfoBasePageRspBo = dycActProcessModel.queryActivityChangeApprovePageList(dycProcessDO);
        DycActQueryActivityChangeApprovePageListRspBO rspBO = JSON.parseObject(JSON.toJSONString(dycActActivityApproveBaseInfoBasePageRspBo), DycActQueryActivityChangeApprovePageListRspBO.class);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
