package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeRspDO;
import com.tydic.dyc.act.service.api.DycActQueryActivityChangeBaseInfoService;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangeBaseInfoReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangeBaseInfoRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActQueryActivityChangeBaseInfoServiceImpl
 * 说明：活动变更单基本信息查询服务
 * 时间： 2023-12-22 14:18
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActQueryActivityChangeBaseInfoServiceImpl implements DycActQueryActivityChangeBaseInfoService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActQueryActivityChangeBaseInfoRspBO queryActivityChangeBaseInfo(DycActQueryActivityChangeBaseInfoReqBO reqBO) {
        DycActivityChangeDO activityChangeDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityChangeDO.class);
        DycActivityChangeRspDO dycActivityChangeRspDO = dycActivityChangeModel.queryActivityChangeBaseInfo(activityChangeDO);
        DycActQueryActivityChangeBaseInfoRspBO rspBO = JSON.parseObject(JSON.toJSONString(dycActivityChangeRspDO), DycActQueryActivityChangeBaseInfoRspBO.class);
        return rspBO;
    }
}
