package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityCatalogInfo;
import com.tydic.dyc.act.service.api.DycActQueryActivityChangeCommodityCatalogPageListService;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangeSelectedCommodityCatalogPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangeSelectedCommodityCatalogPageListRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 说明：活动变更已选商品类型列表查询（分页）服务
 *
 * @author zhoulu
 * @date 2023年12月25日 14:15
 */
@HTServiceImpl
public class DycActQueryActivityChangeCommodityCatalogPageListServiceImpl implements DycActQueryActivityChangeCommodityCatalogPageListService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActQueryActivityChangeSelectedCommodityCatalogPageListRspBO queryActivityChangeSelectedCommodityCatalogPageList(DycActQueryActivityChangeSelectedCommodityCatalogPageListReqBO reqBO) {
        if (reqBO.getChangeId() == null) {
            throw new ZTBusinessException("变更单id不能为空!");
        }
        DycActivityChangeDO dycActivityChangeDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityChangeDO.class);
        BasePageRspBo<DycActivityChangeRelaCommodityCatalogInfo> dycActivityChangeRelaCommodityCatalogInfoBasePageRspBo = dycActivityChangeModel.queryActivityChangeSelectedCommodityCatalogPageList(dycActivityChangeDO);
        DycActQueryActivityChangeSelectedCommodityCatalogPageListRspBO rspBO = JSON.parseObject(JSON.toJSONString(dycActivityChangeRelaCommodityCatalogInfoBasePageRspBo), DycActQueryActivityChangeSelectedCommodityCatalogPageListRspBO.class);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
