package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityInfo;
import com.tydic.dyc.act.service.api.DycActQueryActivityChangeCommodityPageListService;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangeCommodityPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangeCommodityPageListRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 说明：活动变更已选商品列表查询（分页）服务
 *
 * @author zhoulu
 * @date 2023年12月25日 18:10
 */
@HTServiceImpl
public class DycActQueryActivityChangeCommodityPageListServiceImpl implements DycActQueryActivityChangeCommodityPageListService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;

    @Override
    public DycActQueryActivityChangeCommodityPageListRspBO queryActivityChangeCommodityPageList(DycActQueryActivityChangeCommodityPageListReqBO reqBO) {
        if (reqBO.getChangeId() == null) {
            throw new ZTBusinessException("变更单id不能为空!");
        }
        DycActivityChangeDO dycActivityChangeDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityChangeDO.class);
        BasePageRspBo<DycActivityChangeRelaCommodityInfo> dycActivityChangeRelaCommodityInfoBasePageRspBo = dycActivityChangeModel.queryActivityChangeCommodityPageList(dycActivityChangeDO);
        DycActQueryActivityChangeCommodityPageListRspBO rspBO = JSON.parseObject(JSON.toJSONString(dycActivityChangeRelaCommodityInfoBasePageRspBo), DycActQueryActivityChangeCommodityPageListRspBO.class);
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
