package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.model.api.DycActivityChangeModel;
import com.tydic.dyc.act.model.bo.DycActivityChangeDO;
import com.tydic.dyc.act.model.bo.DycActivityChangeRelaCommodityPoolInfo;
import com.tydic.dyc.act.service.api.DycActQueryActivityChangeCommodityPoolPageListService;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangeCommodityPoolPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityChangeCommodityPoolPageListRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActQueryActivityChangeCommodityPoolPageListServiceImpl
 * 说明：活动变更已选商品池列表查询（分页）服务
 * 时间： 2023-12-25 11:00
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActQueryActivityChangeCommodityPoolPageListServiceImpl implements DycActQueryActivityChangeCommodityPoolPageListService {

    @Autowired
    private DycActivityChangeModel dycActivityChangeModel;


    @Override
    public DycActQueryActivityChangeCommodityPoolPageListRspBO queryActivityChangeCommodityPoolPageList(DycActQueryActivityChangeCommodityPoolPageListReqBO reqBO) {

        DycActivityChangeDO dycActivityChangeDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityChangeDO.class);
        BasePageRspBo<DycActivityChangeRelaCommodityPoolInfo> poolInfoBasePageRspBo = dycActivityChangeModel.queryActivityChangeCommodityPoolPageList(dycActivityChangeDO);
        DycActQueryActivityChangeCommodityPoolPageListRspBO rspBO = JSON.parseObject(JSON.toJSONString(poolInfoBasePageRspBo), DycActQueryActivityChangeCommodityPoolPageListRspBO.class);
        return rspBO;
    }
}
