package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogInfo;
import com.tydic.dyc.act.model.bo.DycActiveCommodityCatalogQueryBO;
import com.tydic.dyc.act.service.api.DycActQueryActivityCommodityCatalogPageListService;
import com.tydic.dyc.act.service.bo.DycActQueryActivityCommodityCatalogPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityCommodityCatalogPageListRspBO;
import com.tydic.dyc.base.bo.BasePageRspBo;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActQueryActivityCommodityCatalogPageListServiceImpl
 * 说明：
 * 时间： 2023-12-14 16:00
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActQueryActivityCommodityCatalogPageListServiceImpl implements DycActQueryActivityCommodityCatalogPageListService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActQueryActivityCommodityCatalogPageListRspBO queryActivityCommodityCatalogPageList(DycActQueryActivityCommodityCatalogPageListReqBO reqBO) {
        DycActiveCommodityCatalogQueryBO dycActiveCommodityCatalogQueryBO = JSON.parseObject(JSON.toJSONString(reqBO), DycActiveCommodityCatalogQueryBO.class);
        BasePageRspBo<DycActiveCommodityCatalogInfo> catalogInfoBasePageRspBo = dycActActivityModel.queryActiveCommodityCatalogList(dycActiveCommodityCatalogQueryBO);
        DycActQueryActivityCommodityCatalogPageListRspBO rspBO = JSON.parseObject(JSON.toJSONString(catalogInfoBasePageRspBo), DycActQueryActivityCommodityCatalogPageListRspBO.class);
        return rspBO;
    }
}
