package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActQueryActivityCommodityPageListService;
import com.tydic.dyc.act.service.bo.DycActQueryActivityCommodityPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityCommodityPageListRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActActiveBaseInfoQueryService
 * 说明：活动已选商品列表分页查询
 * 时间： 2023-12-12 11:12
 * 作者 @author zhoulu
 */
@HTServiceImpl
public class DycActQueryActivityCommodityPageListServiceImpl implements DycActQueryActivityCommodityPageListService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActQueryActivityCommodityPageListRspBO queryActivityCommodityPageList(DycActQueryActivityCommodityPageListReqBO reqBO) {
        if (reqBO.getActivityId() == null) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        return JSON.parseObject(JSON.toJSONString(dycActActivityModel.queryActivityCommodityPageList(dycActivityDO)), DycActQueryActivityCommodityPageListRspBO.class);
    }
}
