package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActQueryActivityUnselectSupplierPageListService;
import com.tydic.dyc.act.service.bo.DycActQueryActivityUnselectSupplierPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityUnselectSupplierPageListRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActActiveBaseInfoQueryService
 * 说明：活动可选供应商列表分页查询服务
 * 时间： 2023-12-12 11:12
 * 作者 @author zhoulu
 */
@HTServiceImpl
public class DycActQueryActivityUnselectSupplierPageListServiceImpl implements DycActQueryActivityUnselectSupplierPageListService {

    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActQueryActivityUnselectSupplierPageListRspBO queryActivityUnselectSupplierPageList(DycActQueryActivityUnselectSupplierPageListReqBO reqBO) {
//        if (reqBO.getExcludeSupplierIdList().size() <1){
//            throw new ZTBusinessException("供应商集合id不能为空！");
//        }
        DycActivityDO dycActivityDO = new DycActivityDO();
        dycActivityDO.setSupplierIds(reqBO.getExcludeSupplierIdList());
        return JSON.parseObject(JSON.toJSONString(dycActActivityModel.queryActivityUnselectSupplierPageList(dycActivityDO)), DycActQueryActivityUnselectSupplierPageListRspBO.class);
    }
}
