package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.service.api.DycActQueryActivityUserPageListService;
import com.tydic.dyc.act.service.bo.DycActQueryActivityUserPageListReqBO;
import com.tydic.dyc.act.service.bo.DycActQueryActivityUserPageListRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 说明：活动已选用户列表分页查询
 *
 * @author zhoulu
 * @date 2023年12月18日 16:26
 */
@HTServiceImpl
public class DycActQueryActivityUserPageListServiceImpl implements DycActQueryActivityUserPageListService {
    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActQueryActivityUserPageListRspBO queryActivityUserPageList(DycActQueryActivityUserPageListReqBO reqBO) {
        if (reqBO.getActivityId() == null) {
            throw new ZTBusinessException("活动id不能为空！");
        }
        DycActivityDO dycActivityDO = JSON.parseObject(JSON.toJSONString(reqBO), DycActivityDO.class);
        return JSON.parseObject(JSON.toJSONString(dycActActivityModel.queryActivityUserPageList(dycActivityDO)), DycActQueryActivityUserPageListRspBO.class);
    }
}
