package com.tydic.dyc.act.service.impl;

import com.alibaba.fastjson.JSON;
import com.tydic.dyc.act.constants.DycActivityRspConstants;
import com.tydic.dyc.act.model.api.DycActActivityModel;
import com.tydic.dyc.act.model.bo.DycActiveBaseInfoSaveReqBO;
import com.tydic.dyc.act.model.bo.DycActivityBaseInfo;
import com.tydic.dyc.act.service.api.DycActSaveActiveBaseInfoService;
import com.tydic.dyc.act.service.bo.DycActSaveActiveBaseInfoReqBO;
import com.tydic.dyc.act.service.bo.DycActSaveActiveBaseInfoRspBO;
import lombok.extern.ohaotian.HTServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;

/**
 * 标题：DycActSaveActiveBaseInfoServiceImpl
 * 说明： 活动基本详情保存
 * 时间： 2023-12-13 14:28
 * 作者 @author LY
 */
@HTServiceImpl
public class DycActSaveActiveBaseInfoServiceImpl implements DycActSaveActiveBaseInfoService {


    @Autowired
    private DycActActivityModel dycActActivityModel;

    @Override
    public DycActSaveActiveBaseInfoRspBO saveActiveBaseInfo(DycActSaveActiveBaseInfoReqBO reqBO) {
        DycActSaveActiveBaseInfoRspBO rspBO = new DycActSaveActiveBaseInfoRspBO();
        DycActiveBaseInfoSaveReqBO saveReqBO = JSON.parseObject(JSON.toJSONString(reqBO), DycActiveBaseInfoSaveReqBO.class);
        DycActivityBaseInfo baseInfo = dycActActivityModel.saveActiveBaseInfo(saveReqBO);
        rspBO.setActivityId(baseInfo.getActivityId());
        rspBO.setRespCode(DycActivityRspConstants.RESP_CODE_SUCCESS);
        rspBO.setRespDesc(DycActivityRspConstants.RESP_DESC_SUCCESS);
        return rspBO;
    }
}
