package com.tydic.dyc.act.utils;

import com.ohaotian.plugin.mq.proxy.util.SnowFlake;

public class DycActivitySequence {

	private static int MAX_ID_NUM = 1 << 12;

    private static SnowFlake snowFlake;

    private static DycActivitySequence ourInstance = new DycActivitySequence();

    public static DycActivitySequence getInstance() {
        return ourInstance;
    }

    private DycActivitySequence() {
        DycActivitySequence.snowFlake = new SnowFlake(DycActivityRandomUtil.randomCenterId(), DycActivityRandomUtil.randomMachineId());
    }

    /**
     * @return 返回64位大致有序的ID
     */
    public long nextId() {
        return DycActivitySequence.snowFlake.nextId();
    }

    /**
     * 批量获取ID。
     * <p>
     * 由于使用SnowFlake算法，同一毫秒内可以生成4096个ID，为了避免毫秒内重复，所以添加此限制。
     *
     * @param idNum 一次获取ID的数量
     * @return
     */
    public long[] nextIds(int idNum) {
        if (idNum > MAX_ID_NUM) {
            throw new IllegalArgumentException("The number of Id can't be greater than " + MAX_ID_NUM);
        }
        long[] ids = new long[idNum];
        for (int i = 0; i < idNum; i++) {
            ids[i] = DycActivitySequence.snowFlake.nextId();
        }
        return ids;
    }
    
}
