/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.repository.impl;

import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.tydic.dyc.act.model.bo.DycActActivityApproveBaseInfo;
import com.tydic.dyc.act.model.bo.DycActiveBaseInfoSaveReqBO;
import com.tydic.dyc.act.model.bo.DycActivityBaseInfo;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycProcessDO;
import com.tydic.dyc.act.repository.api.DycActActivityRepository;
import com.tydic.dyc.act.repository.dao.ActivityBaseInfoMapper;
import com.tydic.dyc.act.repository.po.ActivityBaseInfoPO;
import com.tydic.dyc.act.repository.po.ActivityBaseInfoTimePO;
import com.tydic.dyc.act.utils.DycActivitySequence;
import com.tydic.dyc.act.utils.DycActivityTransFieldUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import java.math.BigDecimal;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Random;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;
import org.springframework.util.StringUtils;

@Service
public class DycActActivityRepositoryImpl
implements DycActActivityRepository {
    @Autowired
    private ActivityBaseInfoMapper activityBaseInfoMapper;

    public BasePageRspBo<DycActivityBaseInfo> queryActivityPageList(DycActivityDO reqBO) {
        ActivityBaseInfoPO selectActivityBaseInfoPO = new ActivityBaseInfoPO();
        BasePageRspBo rspPage = new BasePageRspBo();
        BeanUtils.copyProperties((Object)reqBO, (Object)selectActivityBaseInfoPO);
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.activityBaseInfoMapper.selectByCondition(selectActivityBaseInfoPO));
        if (ObjectUtils.isEmpty((Object)page)) {
            rspPage.setRespCode("0000");
            rspPage.setRespDesc("\u6210\u529f");
            return rspPage;
        }
        ArrayList<DycActivityBaseInfo> activityBaseInfoBOList = new ArrayList<DycActivityBaseInfo>();
        for (ActivityBaseInfoPO activityBaseInfoPO : page.getResult()) {
            DycActivityBaseInfo activityBaseInfoBO = new DycActivityBaseInfo();
            BeanUtils.copyProperties((Object)activityBaseInfoPO, (Object)activityBaseInfoBO);
            activityBaseInfoBO.setInvoiceClassStr(DycActivityTransFieldUtil.InvoiceClass((String)String.valueOf(activityBaseInfoBO.getInvoiceClass())));
            activityBaseInfoBO.setInvoiceTypeStr(DycActivityTransFieldUtil.ActivityType((String)String.valueOf(activityBaseInfoBO.getInvoiceType())));
            activityBaseInfoBO.setActivityTypeStr(DycActivityTransFieldUtil.ActivityType((String)String.valueOf(activityBaseInfoBO.getActivityType())));
            activityBaseInfoBO.setActivityPayModeStr(DycActivityTransFieldUtil.ActivityPayMode((String)String.valueOf(activityBaseInfoBO.getActivityPayMode())));
            activityBaseInfoBO.setActivityStateStr(DycActivityTransFieldUtil.ActivityState((String)activityBaseInfoBO.getActivityState()));
            activityBaseInfoBOList.add(activityBaseInfoBO);
        }
        rspPage.setPageNo(page.getPageNum());
        rspPage.setRows(activityBaseInfoBOList);
        rspPage.setTotal(page.getPages());
        rspPage.setRecordsTotal((int)page.getTotal());
        rspPage.setRespCode("0000");
        rspPage.setRespDesc("\u6210\u529f");
        return rspPage;
    }

    public List<DycActivityBaseInfo> queryActivityList(DycActivityDO reqBO) {
        ActivityBaseInfoPO selectActivityBaseInfoPO = new ActivityBaseInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)selectActivityBaseInfoPO);
        List<ActivityBaseInfoPO> activityBaseInfoPOS = this.activityBaseInfoMapper.selectByCondition(selectActivityBaseInfoPO);
        ArrayList<DycActivityBaseInfo> activityBaseInfoBOList = new ArrayList<DycActivityBaseInfo>();
        if (activityBaseInfoPOS.size() < 1) {
            return activityBaseInfoBOList;
        }
        for (ActivityBaseInfoPO activityBaseInfoPO : activityBaseInfoPOS) {
            DycActivityBaseInfo activityBaseInfoBO = new DycActivityBaseInfo();
            BeanUtils.copyProperties((Object)activityBaseInfoPO, (Object)activityBaseInfoBO);
            activityBaseInfoBO.setActivityStateStr(DycActivityTransFieldUtil.ActivityState((String)activityBaseInfoBO.getActivityState()));
            activityBaseInfoBO.setActivityTypeStr(DycActivityTransFieldUtil.ActivityType((String)String.valueOf(activityBaseInfoBO.getActivityType())));
            activityBaseInfoBOList.add(activityBaseInfoBO);
        }
        return activityBaseInfoBOList;
    }

    public DycActivityBaseInfo saveActiveBaseInfo(DycActiveBaseInfoSaveReqBO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u4fdd\u5b58\u5185\u5bb9\u4e3a\u7a7a\uff01");
        }
        DycActivityBaseInfo rspBO = new DycActivityBaseInfo();
        if (null == reqBO.getActivityId()) {
            ActivityBaseInfoPO insertBO = new ActivityBaseInfoPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)insertBO);
            LocalDateTime now = LocalDateTime.now();
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyyMMdd");
            String formattedDateTime = now.format(formatter);
            Random random = new Random();
            int randomNum = random.nextInt(900) + 100;
            String randomString = "FLHD" + formattedDateTime + randomNum;
            insertBO.setActivityCode(randomString);
            insertBO.setActivityId(DycActivitySequence.getInstance().nextId());
            insertBO.setActivityVersion(1);
            insertBO.setActivityState("1");
            insertBO.setDelFlag(0);
            insertBO.setCreateTime(new Date());
            if (null != reqBO.getMinPrice() && reqBO.getMinPrice().compareTo(BigDecimal.ZERO) < 0) {
                throw new ZTBusinessException("\u5546\u54c1\u6700\u4f4e\u4ef7\u683c\u4e0d\u80fd\u4f4e\u4e8e0\uff01");
            }
            int i = this.activityBaseInfoMapper.insert(insertBO);
            if (1 != i) {
                throw new ZTBusinessException("\u4fdd\u5b58\u5185\u5bb9\u5931\u8d25\uff01");
            }
            rspBO.setActivityId(insertBO.getActivityId());
        } else {
            ActivityBaseInfoPO baseInfoPO = new ActivityBaseInfoPO();
            BeanUtils.copyProperties((Object)reqBO, (Object)baseInfoPO);
            int i = this.activityBaseInfoMapper.update(baseInfoPO);
            if (1 != i) {
                throw new ZTBusinessException("\u66f4\u65b0\u5185\u5bb9\u5931\u8d25\uff01");
            }
        }
        return rspBO;
    }

    public int changeActivityState(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (StringUtils.isEmpty((Object)reqBO.getActivityState())) {
            throw new ZTBusinessException("\u6d3b\u52a8\u72b6\u6001\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ActivityBaseInfoPO activityBaseInfoPO = (ActivityBaseInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ActivityBaseInfoPO.class);
        activityBaseInfoPO.setUpdateTime(new Date());
        return this.activityBaseInfoMapper.update(activityBaseInfoPO);
    }

    public int deleteActivity(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO)) {
            throw new ZTBusinessException("\u5165\u53c2\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getActivityId()) {
            throw new ZTBusinessException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ActivityBaseInfoPO activityBaseInfoPO = (ActivityBaseInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ActivityBaseInfoPO.class);
        activityBaseInfoPO.setUpdateTime(new Date());
        return this.activityBaseInfoMapper.deleteActivity(activityBaseInfoPO);
    }

    public int autoEffectActivity(DycActivityDO reqBO) {
        ActivityBaseInfoPO activityBaseInfoPO = new ActivityBaseInfoPO();
        List<ActivityBaseInfoPO> list = this.activityBaseInfoMapper.selectAutoEffectActivity(activityBaseInfoPO);
        if (list.size() < 1) {
            return 0;
        }
        for (ActivityBaseInfoPO baseInfoPO : list) {
            baseInfoPO.setUpdateTime(new Date());
            baseInfoPO.setActivityState("5");
        }
        return this.activityBaseInfoMapper.batchUpdate(list);
    }

    public DycActivityBaseInfo autoLoseEffectActivity(DycActivityDO reqBO) {
        List<ActivityBaseInfoPO> activityBaseInfoPOS = this.activityBaseInfoMapper.autoLoseEffectActivity();
        DycActivityBaseInfo rspBO = new DycActivityBaseInfo();
        if (CollectionUtils.isEmpty(activityBaseInfoPOS)) {
            return rspBO;
        }
        activityBaseInfoPOS.forEach(item -> {
            item.setActivityState(String.valueOf(7));
            item.setUpdateTime(new Date());
        });
        this.activityBaseInfoMapper.batchUpdate(activityBaseInfoPOS);
        return rspBO;
    }

    public BasePageRspBo<DycActActivityApproveBaseInfo> queryActivityApprovePageList(DycProcessDO reqBO) {
        BasePageRspBo rspBo = new BasePageRspBo();
        ActivityBaseInfoTimePO activityBaseInfoTimePO = (ActivityBaseInfoTimePO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ActivityBaseInfoTimePO.class);
        if ("1".equals(activityBaseInfoTimePO.getTabId())) {
            activityBaseInfoTimePO.setCurrentNodeStatus(1);
        } else if ("2".equals(activityBaseInfoTimePO.getTabId())) {
            activityBaseInfoTimePO.setCurrentNodeStatus(2);
        }
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.activityBaseInfoMapper.queryActivityApprovePageList(activityBaseInfoTimePO));
        if (ObjectUtils.isEmpty((Object)page)) {
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        List activityBaseInfoBOList = JSON.parseArray((String)JSON.toJSONString((Object)page.getResult()), DycActActivityApproveBaseInfo.class);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setRows(activityBaseInfoBOList);
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int)page.getTotal());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }
}

