/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.act.repository.impl;

import cn.hutool.core.util.DesensitizedUtil;
import com.alibaba.fastjson.JSON;
import com.github.pagehelper.Page;
import com.github.pagehelper.PageHelper;
import com.ohaotian.plugin.base.exception.ZTBusinessException;
import com.ohaotian.plugin.db.Sequence;
import com.tydic.dyc.act.model.bo.DycActivityDO;
import com.tydic.dyc.act.model.bo.DycActivityUserInfo;
import com.tydic.dyc.act.model.bo.DycActivityUserScoresUseRecordInfo;
import com.tydic.dyc.act.repository.api.DycActActivityUserRepository;
import com.tydic.dyc.act.repository.dao.ActivityUserInfoMapper;
import com.tydic.dyc.act.repository.dao.ActivityUserScoresUseRecordMapper;
import com.tydic.dyc.act.repository.po.ActivityUserInfoPO;
import com.tydic.dyc.act.repository.po.ActivityUserScoresUseRecordPO;
import com.tydic.dyc.act.repository.po.ActivityUserScoresUseRecordTimePO;
import com.tydic.dyc.act.utils.DycActivityTransFieldUtil;
import com.tydic.dyc.base.bo.BasePageRspBo;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import org.springframework.beans.BeanUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.util.CollectionUtils;
import org.springframework.util.ObjectUtils;

@Service
public class DycActActivityUserRepositoryImpl
implements DycActActivityUserRepository {
    @Autowired
    private ActivityUserInfoMapper activityUserInfoMapper;
    @Autowired
    private ActivityUserScoresUseRecordMapper activityUserScoresUseRecordMapper;

    public BasePageRspBo<DycActivityUserInfo> queryActivityUserPageList(DycActivityDO reqBO) {
        if (reqBO.getActivityId() == null) {
            throw new ZTBusinessException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        BasePageRspBo rspBo = new BasePageRspBo();
        ActivityUserInfoPO activityUserInfoPO = new ActivityUserInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)activityUserInfoPO);
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.activityUserInfoMapper.selectByCondition(activityUserInfoPO));
        if (ObjectUtils.isEmpty((Object)page)) {
            rspBo.setPageNo(reqBO.getPageNo());
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        List activityUserInfos = JSON.parseArray((String)JSON.toJSONString((Object)page.getResult()), DycActivityUserInfo.class);
        activityUserInfos.forEach(item -> item.setPhone(DesensitizedUtil.mobilePhone((String)item.getPhone())));
        rspBo.setRows(activityUserInfos);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int)page.getTotal());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public List<DycActivityUserInfo> queryActivityUserList(DycActivityDO reqBO) {
        if (reqBO.getActivityId() == null) {
            throw new ZTBusinessException("\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ArrayList<DycActivityUserInfo> rspBo = new ArrayList();
        ActivityUserInfoPO activityUserInfoPO = new ActivityUserInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)activityUserInfoPO);
        List<ActivityUserInfoPO> activityUserInfoPOS = this.activityUserInfoMapper.selectByCondition(activityUserInfoPO);
        rspBo = JSON.parseArray((String)JSON.toJSONString(activityUserInfoPOS), DycActivityUserInfo.class);
        return rspBo;
    }

    public int addUser(DycActivityDO reqBO) {
        ActivityUserInfoPO activityUserInfoPO = (ActivityUserInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ActivityUserInfoPO.class);
        activityUserInfoPO.setCreateTime(new Date());
        activityUserInfoPO.setId(Sequence.getInstance().nextId());
        activityUserInfoPO.setDelFlag(0);
        return this.activityUserInfoMapper.insert(activityUserInfoPO);
    }

    public DycActivityUserInfo batchSelectActivityUser(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO) || null == reqBO.getActivityId()) {
            throw new ZTBusinessException("\u4fdd\u5b58\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getActivityUserList())) {
            throw new ZTBusinessException("\u4fdd\u5b58\u5185\u5bb9\u7528\u6237\u4fe1\u606f\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        List<ActivityUserInfoPO> collect = reqBO.getActivityUserList().stream().map(item -> {
            ActivityUserInfoPO activityUserInfoPO = new ActivityUserInfoPO();
            BeanUtils.copyProperties((Object)item, (Object)activityUserInfoPO);
            activityUserInfoPO.setActivityId(reqBO.getActivityId());
            activityUserInfoPO.setCreateUserId(reqBO.getCreateUserId());
            activityUserInfoPO.setCreateUserName(reqBO.getCreateUserName());
            activityUserInfoPO.setCreateTime(new Date());
            activityUserInfoPO.setId(Sequence.getInstance().nextId());
            activityUserInfoPO.setDelFlag(0);
            return activityUserInfoPO;
        }).collect(Collectors.toList());
        int i = this.activityUserInfoMapper.allInsert(collect);
        if (reqBO.getActivityUserList().size() != i) {
            throw new ZTBusinessException("\u4fdd\u5b58\u5185\u5bb9\u7528\u6237\u6dfb\u52a0\u5931\u8d25\uff01");
        }
        return new DycActivityUserInfo();
    }

    public DycActivityUserInfo batchRemoveActivityUser(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO) || null == reqBO.getActivityId()) {
            throw new ZTBusinessException("\u4fdd\u5b58\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (CollectionUtils.isEmpty((Collection)reqBO.getUserIdList())) {
            throw new ZTBusinessException("\u79fb\u9664\u5217\u8868\u7528\u6237id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        ActivityUserInfoPO userInfoPO = new ActivityUserInfoPO();
        userInfoPO.setActivityId(reqBO.getActivityId());
        userInfoPO.setUpdateUserId(reqBO.getUpdateUserId());
        userInfoPO.setUpdateUserName(reqBO.getUpdateUserName());
        userInfoPO.setUpdateTime(new Date());
        this.activityUserInfoMapper.batchRemoveActivityUser(reqBO.getUserIdList(), userInfoPO);
        return new DycActivityUserInfo();
    }

    public DycActivityUserInfo modifyActivityUserScores(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO) || null == reqBO.getActivityId()) {
            throw new ZTBusinessException("\u4fdd\u5b58\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getUserId()) {
            throw new ZTBusinessException("\u53d1\u653e\u5bf9\u5e94\u7528\u6237id\u4e3a\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getGiveScores() || BigDecimal.ZERO.compareTo(reqBO.getGiveScores()) > 0) {
            throw new ZTBusinessException("\u53d1\u653e\u79ef\u5206\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u79ef\u5206\u4e0d\u80fd\u5c0f\u4e8e0\uff01");
        }
        ActivityUserInfoPO activityUserInfoPO = new ActivityUserInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)activityUserInfoPO);
        activityUserInfoPO.setUpdateTime(new Date());
        int i = this.activityUserInfoMapper.update(activityUserInfoPO);
        if (1 != i) {
            throw new ZTBusinessException("\u79ef\u5206\u4fee\u6539\u5931\u8d25\uff01");
        }
        return new DycActivityUserInfo();
    }

    public DycActivityUserInfo batchModifyActivityUserScores(DycActivityDO reqBO) {
        if (ObjectUtils.isEmpty((Object)reqBO) || null == reqBO.getActivityId()) {
            throw new ZTBusinessException("\u4fdd\u5b58\u5185\u5bb9\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u6d3b\u52a8id\u4e0d\u80fd\u4e3a\u7a7a\uff01");
        }
        if (null == reqBO.getGiveScores() || BigDecimal.ZERO.compareTo(reqBO.getGiveScores()) > 0) {
            throw new ZTBusinessException("\u6279\u91cf\u53d1\u653e\u79ef\u5206\u4e0d\u80fd\u4e3a\u7a7a\u6216\u8005\u79ef\u5206\u4e0d\u80fd\u5c0f\u4e8e0\uff01");
        }
        ActivityUserInfoPO activityUserInfoPO = new ActivityUserInfoPO();
        BeanUtils.copyProperties((Object)reqBO, (Object)activityUserInfoPO);
        activityUserInfoPO.setUpdateTime(new Date());
        this.activityUserInfoMapper.update(activityUserInfoPO);
        return new DycActivityUserInfo();
    }

    public BasePageRspBo<DycActivityUserScoresUseRecordInfo> queryActivityUserScoresUseRecordPageList(DycActivityDO reqBO) {
        BasePageRspBo rspBo = new BasePageRspBo();
        ArrayList<DycActivityUserScoresUseRecordInfo> rows = new ArrayList<DycActivityUserScoresUseRecordInfo>();
        ActivityUserScoresUseRecordTimePO activityUserScoresUseRecordTimePO = (ActivityUserScoresUseRecordTimePO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ActivityUserScoresUseRecordTimePO.class);
        Page page = PageHelper.startPage((int)reqBO.getPageNo(), (int)reqBO.getPageSize()).doSelectPage(() -> this.activityUserScoresUseRecordMapper.queryActivityUserScoresUseRecordPageList(activityUserScoresUseRecordTimePO));
        if (ObjectUtils.isEmpty((Object)page)) {
            rspBo.setPageNo(reqBO.getPageNo());
            rspBo.setTotal(0);
            rspBo.setRecordsTotal(0);
            rspBo.setRespCode("0000");
            rspBo.setRespDesc("\u6210\u529f");
            return rspBo;
        }
        for (ActivityUserScoresUseRecordPO activityUserScoresUseRecordPO : page.getResult()) {
            DycActivityUserScoresUseRecordInfo dycActivityUserScoresUseRecordInfo = (DycActivityUserScoresUseRecordInfo)JSON.parseObject((String)JSON.toJSONString((Object)activityUserScoresUseRecordPO), DycActivityUserScoresUseRecordInfo.class);
            dycActivityUserScoresUseRecordInfo.setUseTypeStr(DycActivityTransFieldUtil.UseType((String)dycActivityUserScoresUseRecordInfo.getUseType()));
            rows.add(dycActivityUserScoresUseRecordInfo);
        }
        rspBo.setRows(rows);
        rspBo.setPageNo(page.getPageNum());
        rspBo.setTotal(page.getPages());
        rspBo.setRecordsTotal((int)page.getTotal());
        rspBo.setRespCode("0000");
        rspBo.setRespDesc("\u6210\u529f");
        return rspBo;
    }

    public int deductOrReturnActivityScores(DycActivityDO reqBO) {
        ActivityUserInfoPO activityUserInfoPO = (ActivityUserInfoPO)JSON.parseObject((String)JSON.toJSONString((Object)reqBO), ActivityUserInfoPO.class);
        List<ActivityUserInfoPO> activityUserInfoPOS = this.activityUserInfoMapper.selectByCondition(activityUserInfoPO);
        if (activityUserInfoPOS.size() < 1) {
            throw new ZTBusinessException("\u6ca1\u6709\u6b64\u7528\u6237");
        }
        ActivityUserInfoPO activityUserInfoPO1 = activityUserInfoPOS.get(0);
        ActivityUserScoresUseRecordPO activityUserScoresUseRecordPO = new ActivityUserScoresUseRecordPO();
        activityUserScoresUseRecordPO.setBeforeUseScores(activityUserInfoPO1.getBalanceScores());
        if ("2".equals(reqBO.getOperType())) {
            if (activityUserInfoPO1.getBalanceScores().compareTo(reqBO.getUseScores()) < 0) {
                throw new ZTBusinessException("\u79ef\u5206\u4e0d\u591f\u4e0d\u80fd\u6d88\u8d39");
            }
            activityUserInfoPO1.setBalanceScores(activityUserInfoPO1.getBalanceScores().subtract(reqBO.getUseScores()));
            activityUserInfoPO1.setUsedScores(activityUserInfoPO1.getUsedScores().add(reqBO.getUseScores()));
        } else if ("3".equals(reqBO.getOperType())) {
            activityUserInfoPO1.setBalanceScores(activityUserInfoPO1.getBalanceScores().add(reqBO.getUseScores()));
            activityUserInfoPO1.setUsedScores(activityUserInfoPO1.getUsedScores().subtract(reqBO.getUseScores()));
        } else {
            throw new ZTBusinessException("\u64cd\u4f5c\u5f02\u5e38");
        }
        this.activityUserInfoMapper.update(activityUserInfoPO1);
        activityUserScoresUseRecordPO.setRecordId(Sequence.getInstance().nextId());
        activityUserScoresUseRecordPO.setActivityId(reqBO.getActivityId());
        activityUserScoresUseRecordPO.setActivityName(reqBO.getActivityName());
        activityUserScoresUseRecordPO.setUserId(activityUserInfoPO1.getUserId());
        activityUserScoresUseRecordPO.setUserName(activityUserInfoPO1.getUserName());
        activityUserScoresUseRecordPO.setName(activityUserInfoPO1.getName());
        activityUserScoresUseRecordPO.setUseType(reqBO.getOperType());
        activityUserScoresUseRecordPO.setObjId(reqBO.getObjId());
        activityUserScoresUseRecordPO.setObjType(reqBO.getObjType());
        activityUserScoresUseRecordPO.setUseScores(reqBO.getUseScores());
        activityUserScoresUseRecordPO.setAfterUseScores(activityUserInfoPO1.getBalanceScores());
        activityUserScoresUseRecordPO.setUseTime(reqBO.getUseTime());
        activityUserScoresUseRecordPO.setUseUserId(reqBO.getUseUserId());
        activityUserScoresUseRecordPO.setUseUserName(reqBO.getUseUserName());
        activityUserScoresUseRecordPO.setCreateTime(new Date());
        activityUserScoresUseRecordPO.setCreateUserId(reqBO.getUseUserId());
        activityUserScoresUseRecordPO.setCreateUserName(reqBO.getUseUserName());
        return this.activityUserScoresUseRecordMapper.insert(activityUserScoresUseRecordPO);
    }
}

