package com.tydic.dyc.agr.service.portion.bo;

import com.tydic.dyc.base.bo.BaseReqBo;
import lombok.Data;

import java.util.List;

/**
 * @Description: AgrGetPortionListReq
 * @Author: the_xhl
 * @Date: 2023-11-20
 */
@Data
public class AgrGetPortionListReqBO extends BaseReqBo {

    private static final long serialVersionUID = -1415662027267963841L;
    /**
     * 份额id
     */
    private Long portionId;
    /**
     * 份额编号
     */
    private String portionCode;

    /**
     * 份额名称
     */
    private String portionName;

    /**
     * 份额状态
     */
    private String portionStatus;

    /**
     * 管控措施 1预警 2禁止下单
     */
    private String controlType;
    /**
     * 份额维度（共享份额  确定份额）
     */
    private Integer portionType;
    /**
     * 单位名称
     */
    private String purName;
    /**
     * 下单管控方式(份额管控 顺序选取)
     */
    private String orderTube;
    /**
     * 排序
     */
    private String orderBy;

    /**
     * 份额状态集合
     */
    private List<String> portionStatusList;

    /**
     * 当前页
     */
    private Integer pageNo;
    /**
     * 每页条数
     */
    private Integer pageSize;
}
