/*
 * Decompiled with CFR 0.152.
 */
package com.tydic.dyc.agr.components.es.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.components.es.IAgrEsSync;
import com.tydic.dyc.agr.components.es.IAgrEsSyncQryReqBo;
import com.tydic.dyc.agr.components.es.IAgrEsSyncQryRspBo;
import com.tydic.dyc.agr.config.AgrIndexConfig;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AgrEsSyncAgr
implements IAgrEsSync {
    private static final Logger log = LoggerFactory.getLogger(AgrEsSyncAgr.class);
    @Autowired
    private AgrIndexConfig agrIndexConfig;
    @Autowired
    private IAgrAgrModel agrAgrModel;

    @Override
    public String indexName() {
        return this.agrIndexConfig.getAgrIndex();
    }

    @Override
    public IAgrEsSyncQryRspBo qryData(IAgrEsSyncQryReqBo reqBo) {
        IAgrEsSyncQryRspBo rspBo = new IAgrEsSyncQryRspBo();
        Long agrId = reqBo.getAgrId();
        rspBo.setObjId(agrId);
        AgrAgrQryBo qryAgrReq = new AgrAgrQryBo();
        qryAgrReq.setAgrId(agrId);
        AgrAgrDo agrMain = this.agrAgrModel.getAgrMain(qryAgrReq);
        AgrItemListQryReqPageBo qryItemReq = new AgrItemListQryReqPageBo();
        qryItemReq.setAgrId(agrId);
        qryItemReq.setPageNo(1);
        qryItemReq.setPageSize(1);
        AgrItemListQryRspPageBo agrItemList = null;
        try {
            agrItemList = this.agrAgrModel.getAgrItemList(qryItemReq);
        }
        catch (Exception e) {
            log.error("\u67e5\u8be2\u534f\u8bae\u660e\u7ec6\u4fe1\u606f\u5f02\u5e38\uff1a" + e.getMessage());
        }
        JSONObject agrMainObj = JSON.parseObject((String)JSON.toJSONString((Object)agrMain));
        this.setAgrItemInfo(agrMainObj, agrItemList);
        this.translateProperties(agrMainObj, agrMain);
        rspBo.setJsonObj(agrMainObj);
        return rspBo;
    }

    private void setAgrItemInfo(JSONObject agrMainObj, AgrItemListQryRspPageBo agrItemList) {
        if (ObjectUtil.isNotEmpty((Object)agrItemList)) {
            agrMainObj.put("agrItemNumber", (Object)(ObjectUtil.isNotEmpty((Object)agrItemList.getRecordsTotal()) ? agrItemList.getRecordsTotal() : 0));
        }
    }

    private void translateProperties(JSONObject agrMainObj, AgrAgrDo agrMain) {
        if (ObjectUtil.isNotEmpty((Object)agrMain)) {
            if (ObjectUtil.isNotEmpty((Object)agrMain.getAgrStatus())) {
                agrMainObj.put("agrStatusStr", (Object)AgrCommConstant.AgrStatusEnum.getValueByCode((Integer)agrMain.getAgrStatus()));
            }
            if (ObjectUtil.isNotEmpty((Object)agrMain.getAgrSrc())) {
                agrMainObj.put("agrSrcStr", (Object)AgrCommConstant.AgrSrcEnum.getValueByCode((Integer)agrMain.getAgrSrc()));
            }
            if (ObjectUtil.isNotEmpty((Object)agrMain.getAdjustPrice())) {
                agrMainObj.put("adjustPriceStr", (Object)AgrCommConstant.AdjustPriceEnum.getValueByCode((Integer)agrMain.getAdjustPrice()));
            }
            if (ObjectUtil.isNotEmpty((Object)agrMain.getAgrType())) {
                agrMainObj.put("agrTypeStr", (Object)AgrCommConstant.AgrTypeEnum.getValueByCode((Integer)agrMain.getAgrType()));
            }
        }
    }
}

