package com.tydic.dyc.agr.components.es.impl;

import cn.hutool.core.util.ObjectUtil;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.tydic.dyc.agr.components.es.AgrEsFieldConstants;
import com.tydic.dyc.agr.components.es.IAgrEsSync;
import com.tydic.dyc.agr.components.es.IAgrEsSyncQryReqBo;
import com.tydic.dyc.agr.components.es.IAgrEsSyncQryRspBo;
import com.tydic.dyc.agr.config.AgrIndexConfig;
import com.tydic.dyc.agr.model.agr.AgrAgrDo;
import com.tydic.dyc.agr.model.agr.IAgrAgrModel;
import com.tydic.dyc.agr.model.agr.qrybo.AgrAgrQryBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryReqPageBo;
import com.tydic.dyc.agr.model.agr.qrybo.AgrItemListQryRspPageBo;
import com.tydic.dyc.agr.service.constants.AgrCommConstant;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

/**
 * 标题:AgrEsSyncAgr
 * 说明:协议数据同步es
 * 时间:2022/8/29 14:56
 * 作者:田桂银
 */
@Component
@Slf4j
public class AgrEsSyncAgr implements IAgrEsSync {

    @Autowired
    private AgrIndexConfig agrIndexConfig;

    @Autowired
    private IAgrAgrModel agrAgrModel;

    @Override
    public String indexName() {
        return agrIndexConfig.getAgrIndex();
    }

    @Override
    public IAgrEsSyncQryRspBo qryData(IAgrEsSyncQryReqBo reqBo) {
        IAgrEsSyncQryRspBo rspBo = new IAgrEsSyncQryRspBo();
        Long agrId = reqBo.getAgrId();
        rspBo.setObjId(agrId);
        AgrAgrQryBo qryAgrReq = new AgrAgrQryBo();
        qryAgrReq.setAgrId(agrId);
        AgrAgrDo agrMain = agrAgrModel.getAgrMain(qryAgrReq);

        AgrItemListQryReqPageBo qryItemReq = new AgrItemListQryReqPageBo();
        qryItemReq.setAgrId(agrId);
        qryItemReq.setPageNo(1);
        qryItemReq.setPageSize(1);
        AgrItemListQryRspPageBo agrItemList = null;
        try {
            agrItemList = agrAgrModel.getAgrItemList(qryItemReq);
        } catch (Exception e) {
            log.error("查询协议明细信息异常：" + e.getMessage());
        }

        //协议主体信息
        JSONObject agrMainObj = JSON.parseObject(JSON.toJSONString(agrMain));

        //设置协议明细信息
        setAgrItemInfo(agrMainObj, agrItemList);
        //TODO 翻译字段还未入到es，等翻译服务出来再补上相关业务
        //翻译
        translateProperties(agrMainObj,agrMain);

        //设置json数据
        rspBo.setJsonObj(agrMainObj);
        return rspBo;
    }
    private void setAgrItemInfo(JSONObject agrMainObj, AgrItemListQryRspPageBo agrItemList) {
        if (ObjectUtil.isNotEmpty(agrItemList)) {
            agrMainObj.put(AgrEsFieldConstants.AGR_MAIN_OTHER.AGR_ITEM_NUMBER,
                    ObjectUtil.isNotEmpty(agrItemList.getRecordsTotal()) ? agrItemList.getRecordsTotal() : 0);

        }
    }

    /**
     * 翻译出参转义字段
     */
    private void translateProperties(JSONObject agrMainObj, AgrAgrDo agrMain){
        if (ObjectUtil.isNotEmpty(agrMain)){
            //协议状态翻译
            if (ObjectUtil.isNotEmpty(agrMain.getAgrStatus())){
                agrMainObj.put(AgrEsFieldConstants.AGR_MAIN_OTHER.AGR_STATUS_STR,
                        AgrCommConstant.AgrStatusEnum.getValueByCode(agrMain.getAgrStatus()));
            }
            //协议来源翻译
            if (ObjectUtil.isNotEmpty(agrMain.getAgrSrc())){
                agrMainObj.put(AgrEsFieldConstants.AGR_MAIN_OTHER.AGR_SRC_STR,
                        AgrCommConstant.AgrSrcEnum.getValueByCode(agrMain.getAgrSrc()));
            }
            //调价机制翻译
            if (ObjectUtil.isNotEmpty(agrMain.getAdjustPrice())){
                agrMainObj.put(AgrEsFieldConstants.AGR_MAIN_OTHER.ADJUST_PRICE_STR,
                        AgrCommConstant.AdjustPriceEnum.getValueByCode(agrMain.getAdjustPrice()));
            }
            //协议分类翻译
            if (ObjectUtil.isNotEmpty(agrMain.getAgrType())){
                agrMainObj.put(AgrEsFieldConstants.AGR_MAIN_OTHER.AGR_TYPE_STR,
                        AgrCommConstant.AgrTypeEnum.getValueByCode(agrMain.getAgrType()));
            }
        }
    }
}


